/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Optional;
import java.util.concurrent.Callable;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.HasReconnectionConfig;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;

public class ClassLoaderConnectionProviderWrapper<C>
extends ConnectionProviderWrapper<C> {
    private final ClassLoader classLoader;

    public static <C> ClassLoaderConnectionProviderWrapper<C> newInstance(ConnectionProvider<C> provider, ClassLoader classLoader) {
        return provider instanceof PoolingConnectionProvider ? new PoolingClassLoaderConnectionProviderWrapper(provider, classLoader) : new ClassLoaderConnectionProviderWrapper<C>(provider, classLoader);
    }

    private ClassLoaderConnectionProviderWrapper(ConnectionProvider<C> provider, ClassLoader classLoader) {
        super(provider);
        this.classLoader = classLoader;
    }

    @Override
    public C connect() throws ConnectionException {
        return (C)this.onClassLoader(() -> this.getDelegate().connect(), ConnectionException.class);
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        return this.onClassLoader(() -> this.getDelegate().validate(connection));
    }

    @Override
    public void disconnect(C connection) {
        this.onClassLoader(() -> this.getDelegate().disconnect(connection));
    }

    @Override
    public void initialise() throws InitialisationException {
        this.onClassLoader(() -> super.initialise(), InitialisationException.class);
    }

    @Override
    public void start() throws MuleException {
        this.onClassLoader(() -> super.start(), MuleException.class);
    }

    @Override
    public void stop() throws MuleException {
        this.onClassLoader(() -> super.stop(), MuleException.class);
    }

    @Override
    public void dispose() {
        this.onClassLoader(() -> super.dispose());
    }

    @Override
    public Optional<ReconnectionConfig> getReconnectionConfig() {
        ConnectionProvider delegate = this.getDelegate();
        if (delegate instanceof HasReconnectionConfig) {
            return ((HasReconnectionConfig)((Object)delegate)).getReconnectionConfig();
        }
        return Optional.empty();
    }

    protected void onClassLoader(CheckedRunnable runnable) {
        this.onClassLoader(runnable, RuntimeException.class);
    }

    private <T> T onClassLoader(Callable<T> callable) {
        return this.onClassLoader(callable, RuntimeException.class);
    }

    private <E extends Exception> void onClassLoader(CheckedRunnable runnable, Class<E> expectedException) throws E {
        this.onClassLoader(() -> {
            runnable.run();
            return null;
        }, expectedException);
    }

    private <T, E extends Exception> T onClassLoader(Callable<T> callable, Class<E> expectedException) throws E {
        return (T)ClassUtils.withContextClassLoader(this.classLoader, callable, expectedException, e -> {
            throw new MuleRuntimeException(e);
        });
    }

    private static class PoolingClassLoaderConnectionProviderWrapper<C>
    extends ClassLoaderConnectionProviderWrapper<C>
    implements PoolingConnectionProvider<C> {
        private PoolingClassLoaderConnectionProviderWrapper(ConnectionProvider provider, ClassLoader classLoader) {
            super(provider, classLoader);
            Preconditions.checkArgument(provider instanceof PoolingConnectionProvider, "Delegate is not a pooling provider");
        }

        @Override
        public void onBorrow(C connection) {
            this.onClassLoader(() -> this.getPoolingDelegate().onBorrow(connection));
        }

        @Override
        public void onReturn(C connection) {
            this.onClassLoader(() -> this.getPoolingDelegate().onReturn(connection));
        }

        private PoolingConnectionProvider<C> getPoolingDelegate() {
            return (PoolingConnectionProvider)this.getDelegate();
        }
    }
}

