/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.el.metadata.loaders;

import java.io.Serializable;
import java.net.URI;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.weave.v2.el.metadata.WeaveTypesConverter$;
import org.mule.weave.v2.el.metadata.loaders.ClassLoaderResourceResolver;
import org.mule.weave.v2.el.metadata.loaders.ResourceResolver;
import org.mule.weave.v2.parser.ModuleParser$;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.phase.ModuleLoader;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.utils.WeaveTypeEmitter$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001#\t1\"j]8o'\u000eDW-\\1N_\u0012,H.\u001a'pC\u0012,'O\u0003\u0002\u0004\t\u00059An\\1eKJ\u001c(BA\u0003\u0007\u0003!iW\r^1eCR\f'BA\u0004\t\u0003\t)GN\u0003\u0002\n\u0015\u0005\u0011aO\r\u0006\u0003\u00171\tQa^3bm\u0016T!!\u0004\b\u0002\t5,H.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tIb$D\u0001\u001b\u0015\tYB$A\u0003qQ\u0006\u001cXM\u0003\u0002\u001e\u0011\u00051\u0001/\u0019:tKJL!a\b\u000e\u0003\u00195{G-\u001e7f\u0019>\fG-\u001a:\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001b\u0002\u0014\u0001\u0001\u0004%\taJ\u0001\u0011e\u0016\u001cx.\u001e:dKJ+7o\u001c7wKJ,\u0012\u0001\u000b\t\u0003I%J!A\u000b\u0002\u0003!I+7o\\;sG\u0016\u0014Vm]8mm\u0016\u0014\bb\u0002\u0017\u0001\u0001\u0004%\t!L\u0001\u0015e\u0016\u001cx.\u001e:dKJ+7o\u001c7wKJ|F%Z9\u0015\u00059\n\u0004CA\n0\u0013\t\u0001DC\u0001\u0003V]&$\bb\u0002\u001a,\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\n\u0004B\u0002\u001b\u0001A\u0003&\u0001&A\tsKN|WO]2f%\u0016\u001cx\u000e\u001c<fe\u0002BQA\u000e\u0001\u0005B]\n!\u0002\\8bI6{G-\u001e7f)\rA\u0014*\u0015\t\u0004'eZ\u0014B\u0001\u001e\u0015\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011\u0004\u0010 \n\u0005uR\"a\u0003)iCN,'+Z:vYR\u00042!G B\u0013\t\u0001%DA\u0007QCJ\u001c\u0018N\\4SKN,H\u000e\u001e\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000ba!\\8ek2,'B\u0001$\u001d\u0003\r\t7\u000f^\u0005\u0003\u0011\u000e\u0013!\"T8ek2,gj\u001c3f\u0011\u0015QU\u00071\u0001L\u00039q\u0017-\\3JI\u0016tG/\u001b4jKJ\u0004\"\u0001T(\u000e\u00035S!AT#\u0002\u0013Y\f'/[1cY\u0016\u001c\u0018B\u0001)N\u00059q\u0015-\\3JI\u0016tG/\u001b4jKJDQAU\u001bA\u0002M\u000ba\u0002]1sg&twmQ8oi\u0016DH\u000f\u0005\u0002\u001a)&\u0011QK\u0007\u0002\u000f!\u0006\u00148/\u001b8h\u0007>tG/\u001a=u\u0011\u00159\u0006\u0001\"\u0011Y\u00035iw\u000eZ;mK\u000e{g\u000e^3oiR\u0019\u0011,\u001a4\u0011\u0007MI$\f\u0005\u0002\\E:\u0011A\f\u0019\t\u0003;Ri\u0011A\u0018\u0006\u0003?B\ta\u0001\u0010:p_Rt\u0014BA1\u0015\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005$\u0002\"\u0002&W\u0001\u0004Y\u0005\"\u0002*W\u0001\u0004\u0019\u0006\"\u00025\u0001\t\u0003J\u0017\u0001\u00028b[\u0016$\u0012!\u0017")
public class JsonSchemaModuleLoader
implements ModuleLoader {
    private ResourceResolver resourceResolver;

    public ResourceResolver resourceResolver() {
        return this.resourceResolver;
    }

    public void resourceResolver_$eq(ResourceResolver x$1) {
        this.resourceResolver = x$1;
    }

    @Override
    public Option<PhaseResult<ParsingResult<ModuleNode>>> loadModule(NameIdentifier nameIdentifier, ParsingContext parsingContext) {
        return this.moduleContent(nameIdentifier, parsingContext).map((Function1 & Serializable & scala.Serializable)str -> {
            DefaultWeaveResource resource = WeaveResource$.MODULE$.apply(NameIdentifierHelper$.MODULE$.toWeaveFilePath(nameIdentifier), (String)str);
            PhaseResult<ParsingResult<ModuleNode>> moduleParsingResult = ModuleParser$.MODULE$.parse(ModuleParser$.MODULE$.parsingPhase(), resource, parsingContext);
            return moduleParsingResult;
        });
    }

    @Override
    public Option<String> moduleContent(NameIdentifier nameIdentifier, ParsingContext parsingContext) {
        Option<URI> identifier = this.resourceResolver().resolve(nameIdentifier, ".json");
        return identifier.flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            None$ none$;
            BufferedSource source = Source$.MODULE$.fromURI(uri, Codec$.MODULE$.UTF8());
            String jsonSchemaContent = source.mkString();
            JsonTypeLoader loader = new JsonTypeLoader(jsonSchemaContent, (URI)uri);
            Optional<MetadataType> rootType = loader.load("");
            if (rootType.isPresent()) {
                MetadataType metadataType = rootType.get();
                WeaveType weaveType = WeaveTypesConverter$.MODULE$.toWeaveType(metadataType);
                String str = WeaveTypeEmitter$.MODULE$.toCatalogString(weaveType);
                none$ = new Some((Object)str);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    @Override
    public Option<String> name() {
        return new Some((Object)"jsonschema");
    }

    public JsonSchemaModuleLoader() {
        ModuleLoader.$init$(this);
        this.resourceResolver = new ClassLoaderResourceResolver();
    }
}

