/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.chain;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SubflowMessageProcessorChainBuilder
extends DefaultMessageProcessorChainBuilder
implements Component {
    private volatile Map<QName, Object> annotations = Collections.emptyMap();
    private final Object rootContainerLocationInitLock = new Object();
    private volatile Location rootContainerLocation;

    @Override
    public Object getAnnotation(QName qName) {
        return this.annotations.get(qName);
    }

    @Override
    public Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations = new HashMap<QName, Object>(newAnnotations);
    }

    @Override
    public ComponentLocation getLocation() {
        return (ComponentLocation)this.getAnnotation(AbstractComponent.LOCATION_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location getRootContainerLocation() {
        if (this.rootContainerLocation == null) {
            Object object = this.rootContainerLocationInitLock;
            synchronized (object) {
                if (this.rootContainerLocation == null) {
                    String rootContainerName = (String)this.getAnnotation(AbstractComponent.ROOT_CONTAINER_NAME_KEY);
                    if (rootContainerName == null) {
                        rootContainerName = this.getLocation().getRootContainerName();
                    }
                    this.rootContainerLocation = Location.builder().globalName(rootContainerName).build();
                }
            }
        }
        return this.rootContainerLocation;
    }

    @Override
    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorForLifecycle) {
        return new SubFlowMessageProcessorChain(this.name, head, processors, processorForLifecycle);
    }

    static class SubFlowMessageProcessorChain
    extends DefaultMessageProcessorChainBuilder.DefaultMessageProcessorChain {
        private String subFlowName;

        SubFlowMessageProcessorChain(String name, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
            super(name, Optional.empty(), head, processors, processorsForLifecycle);
            this.subFlowName = name;
        }

        private Consumer<CoreEvent> pushSubFlowFlowStackElement() {
            return event -> {
                if (DefaultMuleConfiguration.isFlowTrace()) {
                    ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.subFlowName, null));
                }
            };
        }

        private Consumer<CoreEvent> popSubFlowFlowStackElement() {
            return event -> {
                if (DefaultMuleConfiguration.isFlowTrace()) {
                    ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
                }
            };
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Flux.from(publisher).concatMap(event -> Mono.just((Object)event).doOnNext(this.pushSubFlowFlowStackElement()).transform(s -> super.apply((Publisher<CoreEvent>)s)).doOnSuccessOrError((result, throwable) -> this.popSubFlowFlowStackElement().accept((CoreEvent)event)));
        }
    }
}

