/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class LazyExecutionContext<M extends ComponentModel>
implements EventedExecutionContext<M> {
    private final Map<String, LazyValue<Object>> valueResolvers;
    private final M componentModel;
    private final ExtensionModel extensionModel;
    private final ValueResolvingContext resolvingContext;

    public LazyExecutionContext(ResolverSet resolverSet, M componentModel, ExtensionModel extensionModel, ValueResolvingContext resolvingContext) {
        this.resolvingContext = resolvingContext;
        this.valueResolvers = this.getValueResolvers(resolverSet);
        this.componentModel = componentModel;
        this.extensionModel = extensionModel;
    }

    private Map<String, LazyValue<Object>> getValueResolvers(ResolverSet resolverSet) {
        HashMap<String, LazyValue<Object>> valueResolvers = new HashMap<String, LazyValue<Object>>();
        resolverSet.getResolvers().forEach((key, resolver) -> valueResolvers.put((String)key, this.lazy((ValueResolver)resolver)));
        return valueResolvers;
    }

    private LazyValue<Object> lazy(ValueResolver resolver) {
        return new LazyValue<Object>(() -> resolver.resolve(this.resolvingContext));
    }

    @Override
    public boolean hasParameter(String parameterName) {
        return this.valueResolvers.containsKey(parameterName);
    }

    @Override
    public <T> T getParameter(String parameterName) {
        if (this.hasParameter(parameterName)) {
            return (T)this.valueResolvers.get(parameterName).get();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.valueResolvers.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((LazyValue)entry.getValue()).get())));
    }

    @Override
    public Optional<ConfigurationInstance> getConfiguration() {
        return this.resolvingContext.getConfig();
    }

    @Override
    public CoreEvent getEvent() {
        return this.resolvingContext.getEvent();
    }

    @Override
    public void changeEvent(CoreEvent updated) {
        this.resolvingContext.changeEvent(updated);
    }

    @Override
    public M getComponentModel() {
        return this.componentModel;
    }

    @Override
    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }
}

