/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.connection.util.ConnectionProviderUtils;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OAuthOperationMessageProcessor
extends OperationMessageProcessor {
    private static Logger LOGGER = LoggerFactory.getLogger(OAuthOperationMessageProcessor.class);

    public OAuthOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager, ReflectionCache reflectionCache) {
        super(extensionModel, operationModel, configurationProvider, target, targetValue, resolverSet, cursorProviderFactory, retryPolicyTemplate, extensionManager, policyManager, reflectionCache);
    }

    @Override
    protected Mono<CoreEvent> doProcess(CoreEvent event, final ExecutionContextAdapter<OperationModel> operationContext) {
        return super.doProcess(event, operationContext).onErrorResume(AccessTokenExpiredException.class, e -> {
            final OAuthConnectionProviderWrapper connectionProvider = this.getOAuthConnectionProvider(operationContext);
            if (connectionProvider == null) {
                return Mono.error((Throwable)e);
            }
            AccessTokenExpiredException expiredException = this.getTokenExpirationException((Exception)e);
            if (expiredException == null) {
                return Mono.error((Throwable)e);
            }
            final Reference resourceOwnerIdReference = new Reference(Optional.empty());
            connectionProvider.getGrantType().accept(new OAuthGrantTypeVisitor(){

                @Override
                public void visit(AuthorizationCodeGrantType grantType) {
                    AuthorizationCodeConnectionProviderWrapper cp = (AuthorizationCodeConnectionProviderWrapper)connectionProvider;
                    String rsId = cp.getResourceOwnerId();
                    resourceOwnerIdReference.set(Optional.of(rsId));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("AccessToken for resourceOwner '%s' expired while executing operation '%s:%s' using config '%s'. Will attempt to refresh token and retry operation", rsId, OAuthOperationMessageProcessor.this.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), operationContext.getConfiguration().get().getName()));
                    }
                }

                @Override
                public void visit(ClientCredentialsGrantType grantType) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("AccessToken for expired while executing operation '%s:%s' using config '%s'. Will attempt to refresh token and retry operation", OAuthOperationMessageProcessor.this.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), operationContext.getConfiguration().get().getName()));
                    }
                }
            });
            Optional<String> resourceOwnerId = resourceOwnerIdReference.get();
            try {
                connectionProvider.refreshToken(resourceOwnerId.orElse(""));
            }
            catch (Exception refreshException) {
                return Mono.error((Throwable)new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("AccessToken %s expired while executing operation '%s:%s' using config '%s'. Refresh token workflow was attempted but failed with the following exception", this.forResourceOwner(resourceOwnerId), this.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), operationContext.getConfiguration().get().getName())), (Throwable)refreshException));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Access Token successfully refreshed %s on config '%s'", this.forResourceOwner(resourceOwnerId), operationContext.getConfiguration().get().getName()));
            }
            return super.doProcess(event, operationContext);
        });
    }

    private AccessTokenExpiredException getTokenExpirationException(Exception e) {
        return e instanceof AccessTokenExpiredException ? (AccessTokenExpiredException)e : (AccessTokenExpiredException)ExceptionUtils.extractCauseOfType(e, AccessTokenExpiredException.class).orElse(null);
    }

    private OAuthConnectionProviderWrapper getOAuthConnectionProvider(ExecutionContextAdapter operationContext) {
        ConfigurationInstance config = operationContext.getConfiguration().get();
        ConnectionProvider provider = ConnectionProviderUtils.unwrapProviderWrapper(config.getConnectionProvider().get(), OAuthConnectionProviderWrapper.class);
        return provider instanceof OAuthConnectionProviderWrapper ? (OAuthConnectionProviderWrapper)provider : null;
    }

    private String forResourceOwner(Optional<String> resourceOwnerId) {
        return resourceOwnerId.map(id -> String.format("for resource owner '%s' ", id)).orElse("");
    }

    private AccessTokenExpiredException getTokenExpirationException(Throwable t) {
        return t instanceof AccessTokenExpiredException ? (AccessTokenExpiredException)t : (AccessTokenExpiredException)ExceptionUtils.extractOfType(t, AccessTokenExpiredException.class).orElse(null);
    }
}

