/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.privileged.exception.MessageRedeliveredException;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class OnErrorPropagateHandler
extends TemplateOnErrorHandler {
    @Override
    public boolean acceptsAll() {
        return this.errorTypeMatcher == null && this.when == null;
    }

    @Override
    protected Function<CoreEvent, CoreEvent> beforeRouting(Exception exception) {
        return event -> {
            event = super.beforeRouting(exception).apply((CoreEvent)event);
            if (!this.isRedeliveryExhausted(exception) && this.isOwnedTransaction()) {
                this.rollback(exception);
            }
            return event;
        };
    }

    private boolean isTransactionInGlobalErrorHandler(String transactionRootContainer) {
        return this.flowLocation.isPresent() && transactionRootContainer.equals(((Location)this.flowLocation.get()).getGlobalName());
    }

    private boolean isOwnedTransaction() {
        TransactionAdapter transaction = (TransactionAdapter)TransactionCoordination.getInstance().getTransaction();
        if (transaction == null || !transaction.getComponentLocation().isPresent()) {
            return false;
        }
        String transactionContainerName = transaction.getComponentLocation().get().getRootContainerName();
        return transactionContainerName.equals(this.getRootContainerLocation().getGlobalName()) || this.isTransactionInGlobalErrorHandler(transactionContainerName);
    }

    @Override
    public TemplateOnErrorHandler duplicateFor(Location buildFor) {
        OnErrorPropagateHandler cpy = new OnErrorPropagateHandler();
        cpy.setFlowLocation(buildFor);
        cpy.setWhen(this.when);
        cpy.setHandleException(this.handleException);
        cpy.setErrorType(this.errorType);
        cpy.setMessageProcessors(this.getMessageProcessors());
        cpy.setEnableNotifications(this.isEnableNotifications());
        cpy.setLogException(this.logException);
        cpy.setNotificationFirer(this.notificationFirer);
        cpy.setAnnotations(this.getAnnotations());
        return cpy;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return new ArrayList<Processor>(super.getOwnedMessageProcessors());
    }

    private boolean isRedeliveryExhausted(Exception exception) {
        return exception instanceof MessageRedeliveredException;
    }

    @Override
    protected Function<CoreEvent, Publisher<CoreEvent>> route(Exception exception) {
        if (!this.isRedeliveryExhausted(exception)) {
            return super.route(exception);
        }
        this.logger.info("Message redelivery exhausted. No redelivery exhausted actions configured. Message consumed.");
        return event -> Mono.just((Object)event);
    }
}

