/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.deployment.model.api.application.ApplicationClassLoader;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;

public class MuleApplicationClassLoader
extends MuleDeployableArtifactClassLoader
implements ApplicationClassLoader {
    private NativeLibraryFinder nativeLibraryFinder;

    public MuleApplicationClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parentCl, NativeLibraryFinder nativeLibraryFinder, List<URL> urls, ClassLoaderLookupPolicy lookupPolicy, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        super(artifactId, artifactDescriptor, urls.toArray(new URL[0]), parentCl, lookupPolicy, artifactPluginClassLoaders);
        this.nativeLibraryFinder = nativeLibraryFinder;
    }

    @Override
    protected String findLibrary(String name) {
        String libraryPath = super.findLibrary(name);
        libraryPath = this.nativeLibraryFinder.findLibrary(name, libraryPath);
        return libraryPath;
    }

    @Override
    protected String[] getLocalResourceLocations() {
        ClassLoaderModel classLoaderModel = ((ApplicationDescriptor)this.getArtifactDescriptor()).getClassLoaderModel();
        return new String[]{FileUtils.toFile((URL)classLoaderModel.getUrls()[0]).getPath()};
    }

    public static List<ClassLoader> resolveContextArtifactPluginClassLoaders() {
        HashSet<ClassLoader> resolvedClassLoaders = new HashSet<ClassLoader>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        resolvedClassLoaders.addAll(MuleApplicationClassLoader.resolveContextArtifactPluginClassLoadersForCurrentClassLoader());
        ClassLoader tmpClassLoader = originalClassLoader;
        while (tmpClassLoader.getParent() != null && MuleDeployableArtifactClassLoader.class.isAssignableFrom(tmpClassLoader.getParent().getClass())) {
            try {
                tmpClassLoader = tmpClassLoader.getParent();
                Thread.currentThread().setContextClassLoader(tmpClassLoader);
                resolvedClassLoaders.addAll(MuleApplicationClassLoader.resolveContextArtifactPluginClassLoadersForCurrentClassLoader());
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        return new ArrayList<ClassLoader>(resolvedClassLoaders);
    }

    private static List<ClassLoader> resolveContextArtifactPluginClassLoadersForCurrentClassLoader() {
        List artifactPluginClassLoaders;
        Method getArtifactPluginClassLoaders;
        try {
            getArtifactPluginClassLoaders = Thread.currentThread().getContextClassLoader().getClass().getMethod("getArtifactPluginClassLoaders", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return Collections.singletonList(Thread.currentThread().getContextClassLoader());
        }
        try {
            artifactPluginClassLoaders = (List)getArtifactPluginClassLoaders.invoke((Object)Thread.currentThread().getContextClassLoader(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new MuleRuntimeException(e);
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(artifactPluginClassLoaders.stream().map(acl -> {
            try {
                return acl.getClass().getMethod("getClassLoader", new Class[0]).invoke(acl, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new MuleRuntimeException(e);
            }
        }).collect(Collectors.toList()));
        return classLoaders;
    }

    static {
        MuleApplicationClassLoader.registerAsParallelCapable();
    }
}

