/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;

public final class JavaExportedTypesDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.INITIALIZE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        Optional<ExtensionTypeDescriptorModelProperty> modelProperty = ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getModelProperty(ExtensionTypeDescriptorModelProperty.class);
        modelProperty.map(ExtensionTypeDescriptorModelProperty::getType).flatMap(type -> type.getValueFromAnnotation(Export.class)).ifPresent(exportAnnotation -> {
            ExtensionDeclarer declarer = extensionLoadingContext.getExtensionDeclarer();
            exportAnnotation.getClassArrayValue(Export::classes).stream().map(Type::asMetadataType).forEach(type -> this.registerType(declarer, (MetadataType)type));
            exportAnnotation.getArrayValue(Export::resources).forEach(declarer::withResource);
        });
    }

    private void registerType(final ExtensionDeclarer declarer, MetadataType type) {
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    objectType.getOpenRestriction().get().accept(this);
                } else {
                    declarer.withType(objectType);
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept(this);
            }

            @Override
            public void visitIntersection(IntersectionType intersectionType) {
                intersectionType.getTypes().forEach(type -> type.accept(this));
            }

            @Override
            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept(this));
            }

            @Override
            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept(this);
            }
        });
    }
}

