/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.source.scheduler.Scheduler;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.internal.dsl.DslConstants;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;

public final class InfrastructureTypeMapping {
    public static final String TLS_NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/tls";
    private static Map<Class<?>, InfrastructureType> MAPPING = ImmutableMap.builder().put(TlsContextFactory.class, (Object)new InfrastructureType("tlsContext", 8)).put(SourceTransactionalAction.class, (Object)new InfrastructureType("transactionalAction", 6)).put(OperationTransactionalAction.class, (Object)new InfrastructureType("transactionalAction", 7)).put(TransactionType.class, (Object)new InfrastructureType("transactionType", 9)).put(Scheduler.class, (Object)new InfrastructureType("schedulingStrategy", 10)).build();
    private static Map<Type, InfrastructureType> TYPE_MAPPING = MAPPING.entrySet().stream().collect(Collectors.toImmutableMap(entry -> new TypeWrapper((Class)entry.getKey(), new DefaultExtensionsTypeLoaderFactory().createTypeLoader(InfrastructureTypeMapping.class.getClassLoader())), Map.Entry::getValue));
    private static Map<String, QNameModelProperty> QNAMES = ImmutableMap.builder().put((Object)"schedulingStrategy", (Object)new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "scheduling-strategy", "mule"))).put((Object)"tlsContext", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "context", "tls"))).put((Object)"custom-ocsp-responder", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "custom-ocsp-responder", "tls"))).put((Object)"standard-revocation-check", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "standard-revocation-check", "tls"))).put((Object)"crl-file", (Object)new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "crl-file", "tls"))).build();
    private static Map<String, ParameterDslConfiguration> DSL_CONFIGURATIONS = ImmutableMap.builder().put((Object)"schedulingStrategy", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"tlsContext", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowTopLevelDefinition(true).allowsReferences(true).build()).put((Object)"transactionalAction", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build()).put((Object)"transactionType", (Object)ParameterDslConfiguration.builder().allowsInlineDefinition(false).allowTopLevelDefinition(false).allowsReferences(false).build()).build();
    private static Map<String, String> nameMap = MAPPING.entrySet().stream().collect(Collectors.toImmutableMap(e -> ((Class)e.getKey()).getName(), e -> ((InfrastructureType)e.getValue()).getName()));

    public static Optional<InfrastructureType> getInfrastructureType(Type type) {
        return TYPE_MAPPING.entrySet().stream().filter(entry -> ((Type)entry.getKey()).isSameType(type)).map(Map.Entry::getValue).findFirst();
    }

    public static Map<Class<?>, InfrastructureType> getMap() {
        return MAPPING;
    }

    public static Map<String, String> getNameMap() {
        return nameMap;
    }

    public static Optional<QNameModelProperty> getQName(String name) {
        return Optional.ofNullable(QNAMES.get(name));
    }

    public static Optional<ParameterDslConfiguration> getDslConfiguration(String name) {
        return Optional.ofNullable(DSL_CONFIGURATIONS.get(name));
    }

    private InfrastructureTypeMapping() {
    }

    public static class InfrastructureType {
        private final String name;
        private final int sequence;

        InfrastructureType(String name, int sequence) {
            this.name = name;
            this.sequence = sequence;
        }

        public String getName() {
            return this.name;
        }

        public int getSequence() {
            return this.sequence;
        }
    }
}

