/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeTransformer;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ExpressionTypedValueValueResolver<T>
extends ExpressionValueResolver<TypedValue<T>>
implements Initialisable {
    private final Class<T> expectedClass;
    private TypeSafeTransformer typeSafeTransformer;
    @Inject
    private TransformationService transformationService;

    public ExpressionTypedValueValueResolver(String expression, Class<T> expectedClass) {
        super(expression, DataType.fromType(expectedClass));
        this.expectedClass = expectedClass;
    }

    @Override
    public TypedValue<T> resolve(ValueResolvingContext context) throws MuleException {
        this.initEvaluator();
        TypedValue typedValue = this.resolveTypedValue(context);
        if (!ClassUtils.isInstance(this.expectedClass, typedValue.getValue())) {
            DataType expectedDataType = DataType.builder().type(this.expectedClass).mediaType(typedValue.getDataType().getMediaType()).build();
            return new TypedValue(this.typeSafeTransformer.transform(typedValue.getValue(), typedValue.getDataType(), expectedDataType), expectedDataType);
        }
        return typedValue;
    }

    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.typeSafeTransformer = new TypeSafeTransformer(this.transformationService);
    }
}

