/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.stax.events;

import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import org.mule.apache.xerces.stax.events.XMLEventImpl;
import org.mule.apache.xerces.util.XMLChar;

public final class CharactersImpl
extends XMLEventImpl
implements Characters {
    private final String fData;

    public CharactersImpl(String data, int eventType, Location location) {
        super(eventType, location);
        this.fData = data != null ? data : "";
    }

    @Override
    public String getData() {
        return this.fData;
    }

    @Override
    public boolean isWhiteSpace() {
        int length;
        int n = length = this.fData != null ? this.fData.length() : 0;
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (XMLChar.isSpace(this.fData.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCData() {
        return 12 == this.getEventType();
    }

    @Override
    public boolean isIgnorableWhiteSpace() {
        return 6 == this.getEventType();
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write(this.fData);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }
}

