/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.PrivateOperationsModelProperty;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.processor.chain.ModuleOperationMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.objectfactory.MessageProcessorChainObjectFactory;

public class ModuleOperationMessageProcessorChainFactoryBean
extends MessageProcessorChainObjectFactory {
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private String moduleName;
    private String moduleOperation;
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    protected ConfigurationComponentLocator locator;

    @Override
    public MessageProcessorChain doGetObject() throws Exception {
        MessageProcessorChainBuilder builder = this.getBuilderInstance();
        for (Object processor : this.processors) {
            if (processor instanceof Processor) {
                builder.chain((Processor)processor);
                continue;
            }
            throw new IllegalArgumentException(String.format("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured. Found a %s", processor.getClass().getName()));
        }
        MessageProcessorChain messageProcessorChain = DefaultMessageProcessorChainBuilder.newLazyProcessorChainBuilder((ModuleOperationMessageProcessorChainBuilder)builder, this.muleContext, () -> MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation()).orElse(null));
        messageProcessorChain.setAnnotations(this.getAnnotations());
        messageProcessorChain.setMuleContext(this.muleContext);
        return messageProcessorChain;
    }

    @Override
    protected MessageProcessorChainBuilder getBuilderInstance() {
        ExtensionModel extensionModel = this.getExtensionModelOrFail();
        return new ModuleOperationMessageProcessorChainBuilder(this.properties, this.parameters, extensionModel, this.getOperationModelOrFail(extensionModel), this.muleContext.getExpressionManager());
    }

    private ExtensionModel getExtensionModelOrFail() {
        return this.extensionManager.getExtensions().stream().filter(em -> em.getXmlDslModel().getPrefix().equals(this.moduleName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find any extension under the name of [%s]", this.moduleName)));
    }

    private OperationModel getOperationModelOrFail(ExtensionModel extensionModel) {
        OperationSeeker operationSeeker = new OperationSeeker();
        operationSeeker.walk(extensionModel);
        OperationModel operationModel = operationSeeker.operationModel.orElseGet(() -> extensionModel.getModelProperty(PrivateOperationsModelProperty.class).get().getOperationModel(this.moduleOperation).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find any operation under the name of [%s] for the extension [%s]", this.moduleOperation, this.moduleName))));
        return operationModel;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setModuleOperation(String moduleOperation) {
        this.moduleOperation = moduleOperation;
    }

    private class OperationSeeker
    extends IdempotentExtensionWalker {
        Optional<OperationModel> operationModel = Optional.empty();

        private OperationSeeker() {
        }

        @Override
        protected void onOperation(OperationModel operationModel) {
            if (operationModel.getName().equals(ModuleOperationMessageProcessorChainFactoryBean.this.moduleOperation)) {
                this.operationModel = Optional.of(operationModel);
                this.stop();
            }
        }
    }
}

