/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import java.util.Iterator;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.ExpressionLanguageSessionAdaptor;

class DefaultExpressionManagerSession
implements ExpressionManagerSession {
    private LazyValue<ExpressionLanguageSessionAdaptor> session;
    private ClassLoader evaluationClassLoader;

    public DefaultExpressionManagerSession(LazyValue<ExpressionLanguageSessionAdaptor> session, ClassLoader evaluationClassLoader) {
        this.session = session;
        this.evaluationClassLoader = evaluationClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedValue<?> evaluate(String expression) throws ExpressionExecutionException {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.evaluationClassLoader);
            TypedValue<?> typedValue = this.session.get().evaluate(expression);
            return typedValue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedValue<?> evaluate(String expression, DataType expectedOutputType) throws ExpressionExecutionException {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.evaluationClassLoader);
            TypedValue<?> typedValue = this.session.get().evaluate(expression, expectedOutputType);
            return typedValue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedValue<?> evaluate(String expression, long timeout) throws ExpressionExecutionException {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.evaluationClassLoader);
            TypedValue<?> typedValue = this.session.get().evaluate(expression, timeout);
            return typedValue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    @Override
    public boolean evaluateBoolean(String expression, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue) throws ExpressionRuntimeException {
        return DefaultExpressionManager.resolveBoolean(this.evaluate(expression, DataType.BOOLEAN).getValue(), nullReturnsTrue, nonBooleanReturnsTrue, expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedValue<?> evaluateLogExpression(String expression) throws ExpressionExecutionException {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.evaluationClassLoader);
            TypedValue<?> typedValue = this.session.get().evaluateLogExpression(expression);
            return typedValue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<TypedValue<?>> split(String expression) {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.evaluationClassLoader);
            Iterator<TypedValue<?>> iterator = this.session.get().split(expression);
            return iterator;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    @Override
    public void close() {
        if (this.session.isComputed()) {
            this.session.get().close();
        }
    }
}

