/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.api.connection.util.ConnectionProviderUtils;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.ImmutableAuthorizationCodeState;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public final class ExtensionsOAuthUtils {
    public static AuthorizationCodeState toAuthorizationCodeState(AuthorizationCodeConfig config, ResourceOwnerOAuthContext context) {
        return new ImmutableAuthorizationCodeState(context.getAccessToken(), context.getRefreshToken(), context.getResourceOwnerId(), context.getExpiresIn(), context.getState(), config.getAuthorizationUrl(), config.getAccessTokenUrl(), config.getCallbackConfig().getExternalCallbackUrl(), config.getConsumerKey(), config.getConsumerSecret());
    }

    public static ClientCredentialsLocation toCredentialsLocation(CredentialsPlacement placement) {
        if (placement == CredentialsPlacement.BASIC_AUTH_HEADER) {
            return ClientCredentialsLocation.BASIC_AUTH_HEADER;
        }
        if (placement == CredentialsPlacement.QUERY_PARAMS) {
            return ClientCredentialsLocation.QUERY_PARAMS;
        }
        if (placement == CredentialsPlacement.BODY) {
            return ClientCredentialsLocation.BODY;
        }
        throw new IllegalArgumentException("Unsupported CredentialsPlacement type " + placement.name());
    }

    public static OAuthConnectionProviderWrapper getOAuthConnectionProvider(ExecutionContextAdapter operationContext) {
        ConfigurationInstance config = operationContext.getConfiguration().get();
        ConnectionProvider provider = ConnectionProviderUtils.unwrapProviderWrapper(config.getConnectionProvider().get(), OAuthConnectionProviderWrapper.class);
        return provider instanceof OAuthConnectionProviderWrapper ? (OAuthConnectionProviderWrapper)provider : null;
    }

    private ExtensionsOAuthUtils() {
    }
}

