/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode;

import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.builder.AuthorizationCodeListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class UpdatingAuthorizationCodeState
implements AuthorizationCodeState {
    private AuthorizationCodeState delegate;

    public UpdatingAuthorizationCodeState(final AuthorizationCodeConfig config, AuthorizationCodeOAuthDancer dancer, ResourceOwnerOAuthContext initialContext, final Consumer<ResourceOwnerOAuthContext> onUpdate) {
        this.delegate = ExtensionsOAuthUtils.toAuthorizationCodeState(config, initialContext);
        dancer.addListener(new AuthorizationCodeListener(){

            @Override
            public void onAuthorizationCompleted(ResourceOwnerOAuthContext context) {
                this.update(context);
            }

            @Override
            public void onTokenRefreshed(ResourceOwnerOAuthContext context) {
                this.update(context);
            }

            private void update(ResourceOwnerOAuthContext context) {
                UpdatingAuthorizationCodeState.this.delegate = ExtensionsOAuthUtils.toAuthorizationCodeState(config, context);
                onUpdate.accept(context);
            }
        });
    }

    @Override
    public String getAccessToken() {
        return this.delegate.getAccessToken();
    }

    @Override
    public Optional<String> getRefreshToken() {
        return this.delegate.getRefreshToken();
    }

    @Override
    public String getResourceOwnerId() {
        return this.delegate.getResourceOwnerId();
    }

    @Override
    public Optional<String> getExpiresIn() {
        return this.delegate.getExpiresIn();
    }

    @Override
    public Optional<String> getState() {
        return this.delegate.getState();
    }

    @Override
    public String getAuthorizationUrl() {
        return this.delegate.getAuthorizationUrl();
    }

    @Override
    public String getAccessTokenUrl() {
        return this.delegate.getAccessTokenUrl();
    }

    @Override
    public String getConsumerKey() {
        return this.delegate.getConsumerKey();
    }

    @Override
    public String getConsumerSecret() {
        return this.delegate.getConsumerSecret();
    }

    @Override
    public Optional<String> getExternalCallbackUrl() {
        return this.delegate.getExternalCallbackUrl();
    }
}

