/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ImmutableClientCredentialsState;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.builder.ClientCredentialsListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class UpdatingClientCredentialsState
implements ClientCredentialsState {
    private ClientCredentialsState delegate;

    public UpdatingClientCredentialsState(ClientCredentialsOAuthDancer dancer, ResourceOwnerOAuthContext initialContext, final Consumer<ResourceOwnerOAuthContext> onUpdate) {
        this.updateDelegate(initialContext);
        dancer.addListener(new ClientCredentialsListener(){

            @Override
            public void onTokenRefreshed(ResourceOwnerOAuthContext context) {
                UpdatingClientCredentialsState.this.updateDelegate(context);
                onUpdate.accept(context);
            }
        });
    }

    private void updateDelegate(ResourceOwnerOAuthContext initialContext) {
        this.delegate = new ImmutableClientCredentialsState(initialContext.getAccessToken(), initialContext.getExpiresIn());
    }

    @Override
    public String getAccessToken() {
        return this.delegate.getAccessToken();
    }

    @Override
    public Optional<String> getExpiresIn() {
        return this.delegate.getExpiresIn();
    }
}

