/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.loader.AbstractInterceptable;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InterceptableOperationExecutorWrapper<M extends ComponentModel>
extends AbstractInterceptable
implements ComponentExecutor<M>,
OperationArgumentResolverFactory<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptableOperationExecutorWrapper.class);
    private final ComponentExecutor delegate;

    public InterceptableOperationExecutorWrapper(ComponentExecutor<M> delegate, List<Interceptor> interceptors) {
        super(interceptors);
        this.delegate = delegate;
    }

    @Override
    public Publisher<Object> execute(ExecutionContext<M> executionContext) {
        return this.delegate.execute(executionContext);
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, true, this.muleContext);
        super.initialise();
    }

    @Override
    public void start() throws MuleException {
        super.start();
        LifecycleUtils.startIfNeeded(this.delegate);
    }

    @Override
    public void stop() throws MuleException {
        super.stop();
        LifecycleUtils.stopIfNeeded(this.delegate);
    }

    @Override
    public void dispose() {
        super.dispose();
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
    }

    @Override
    public Function<ExecutionContext<M>, Map<String, Object>> createArgumentResolver(M operationModel) {
        return this.delegate instanceof OperationArgumentResolverFactory ? ((OperationArgumentResolverFactory)((Object)this.delegate)).createArgumentResolver(operationModel) : ec -> Collections.emptyMap();
    }
}

