/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.LifecycleAwareValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class LifecycleInitialiserValueResolverWrapper<T>
extends LifecycleAwareValueResolverWrapper<T> {
    private final MuleContext muleContext;
    private final Set<Reference<Object>> producedObjects = Collections.newSetFromMap(new ConcurrentHashMap());

    public LifecycleInitialiserValueResolverWrapper(ValueResolver<T> delegate, MuleContext muleContext) {
        super(delegate);
        this.muleContext = muleContext;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        Object value = super.resolve(context);
        if (this.producedObjects.add(new Reference(value))) {
            LifecycleState state = this.muleContext.getLifecycleManager().getState();
            if (state.isInitialising() || state.isInitialised()) {
                LifecycleUtils.initialiseIfNeeded(value, this.muleContext);
            }
            if (state.isStarting() || state.isStarted()) {
                LifecycleUtils.startIfNeeded(value);
            }
        }
        return value;
    }

    @Override
    public void dispose() {
        this.producedObjects.clear();
        super.dispose();
    }
}

