/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.source.BackPressureAction;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConfigurer;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class SourceAdapterFactory {
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private final ResolverSet sourceParameters;
    private final ResolverSet successCallbackParameters;
    private final ResolverSet errorCallbackParameters;
    private final CursorProviderFactory cursorProviderFactory;
    private final Optional<BackPressureAction> backPressureAction;
    private final ReflectionCache reflectionCache;
    private final ExpressionManager expressionManager;
    private ConfigurationProperties properties;
    private final MuleContext muleContext;

    public SourceAdapterFactory(ExtensionModel extensionModel, SourceModel sourceModel, ResolverSet sourceParameters, ResolverSet successCallbackParameters, ResolverSet errorCallbackParameters, CursorProviderFactory cursorProviderFactory, MessageSource.BackPressureStrategy backPressureStrategy, ReflectionCache reflectionCache, ExpressionManager expressionManager, ConfigurationProperties properties, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
        this.sourceParameters = sourceParameters;
        this.successCallbackParameters = successCallbackParameters;
        this.errorCallbackParameters = errorCallbackParameters;
        this.cursorProviderFactory = cursorProviderFactory;
        this.backPressureAction = MuleExtensionUtils.toBackPressureAction(backPressureStrategy);
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
        this.properties = properties;
        this.muleContext = muleContext;
    }

    public SourceAdapter createAdapter(Optional<ConfigurationInstance> configurationInstance, SourceCallbackFactory sourceCallbackFactory, Component component, SourceConnectionManager connectionManager, MessagingExceptionResolver exceptionResolver) {
        Source source = MuleExtensionUtils.getSourceFactory(this.sourceModel).createSource();
        try {
            SourceConfigurer sourceConfigurer = new SourceConfigurer(this.sourceModel, component.getLocation(), this.sourceParameters, this.expressionManager, this.properties, this.muleContext);
            source = sourceConfigurer.configure(source, configurationInstance);
            return new SourceAdapter(this.extensionModel, this.sourceModel, source, configurationInstance, this.cursorProviderFactory, sourceCallbackFactory, component, connectionManager, this.sourceParameters, this.successCallbackParameters, this.errorCallbackParameters, exceptionResolver, this.backPressureAction);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not create generator for source '%s'", this.sourceModel.getName())), (Throwable)e);
        }
    }

    public ResolverSet getSourceParameters() {
        return this.sourceParameters;
    }
}

