/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.avro;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.RangeType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.avro.AvroDataFormat;
import org.mule.weave.v2.module.avro.AvroSettings;
import org.mule.weave.v2.module.avro.AvroWriter$;
import org.mule.weave.v2.module.avro.exception.InvalidFieldNameException;
import org.mule.weave.v2.module.avro.exception.InvalidSchemaTypeException;
import org.mule.weave.v2.module.avro.exception.MissingRequiredFieldException;
import org.mule.weave.v2.module.avro.exception.MissingRequiredSettingException;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.math.ScalaNumericAnyConversions;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001=\u0011!\"\u0011<s_^\u0013\u0018\u000e^3s\u0015\t\u0019A!\u0001\u0003bmJ|'BA\u0003\u0007\u0003\u0019iw\u000eZ;mK*\u0011q\u0001C\u0001\u0003mJR!!\u0003\u0006\u0002\u000b],\u0017M^3\u000b\u0005-a\u0011\u0001B7vY\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\t\u00051qO]5uKJL!a\u0007\r\u0003\r]\u0013\u0018\u000e^3s\u0011!i\u0002A!A!\u0002\u0013q\u0012AA8t!\tyB%D\u0001!\u0015\t\t#%\u0001\u0002j_*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u00051yU\u000f\u001e9viN#(/Z1n\u0011!9\u0003A!b\u0001\n\u0003A\u0013\u0001C:fiRLgnZ:\u0016\u0003%\u0002\"AK\u0016\u000e\u0003\tI!\u0001\f\u0002\u0003\u0019\u00053(o\\*fiRLgnZ:\t\u00119\u0002!\u0011!Q\u0001\n%\n\u0011b]3ui&twm\u001d\u0011\t\u0011A\u0002!\u0011!Q\u0001\fE\n1a\u0019;y!\t\u0011T'D\u00014\u0015\t!d!A\u0003n_\u0012,G.\u0003\u00027g\t\tRI^1mk\u0006$\u0018n\u001c8D_:$X\r\u001f;\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\rQTH\u0010\u000b\u0003wq\u0002\"A\u000b\u0001\t\u000bA:\u00049A\u0019\t\u000bu9\u0004\u0019\u0001\u0010\t\u000b\u001d:\u0004\u0019A\u0015\t\u000b\u0001\u0003A\u0011I!\u0002\u000b\u0019dWo\u001d5\u0015\u0003\t\u0003\"!E\"\n\u0005\u0011\u0013\"\u0001B+oSRDQA\u0012\u0001\u0005B\u0005\u000bQa\u00197pg\u0016DQ\u0001\u0013\u0001\u0005\u0002%\u000b1b\u001e:ji\u0016|%M[3diR\u0019!jT/\u0015\u0005-s\u0005CA\tM\u0013\ti%CA\u0002B]fDQ\u0001M$A\u0004EBQ\u0001U$A\u0002E\u000b\u0011A\u001e\t\u0004%V;V\"A*\u000b\u0005Q\u001b\u0014A\u0002<bYV,7/\u0003\u0002W'\n)a+\u00197vKB\u0011\u0001lW\u0007\u00023*\u0011!lM\u0001\ngR\u0014Xo\u0019;ve\u0016L!\u0001X-\u0003\u0013=\u0013'.Z2u'\u0016\f\b\"\u00020H\u0001\u0004y\u0016AB:dQ\u0016l\u0017\r\u0005\u0002aI6\t\u0011M\u0003\u0002\u0004E*\u00111\rD\u0001\u0007CB\f7\r[3\n\u0005\u0015\f'AB*dQ\u0016l\u0017\rC\u0003h\u0001\u0011\u0005\u0001.\u0001\u0006xe&$X-\u0011:sCf$2![;|)\tQG\u000fE\u0002lc.s!\u0001\\8\u000e\u00035T!A\\1\u0002\u000f\u001d,g.\u001a:jG&\u0011\u0001/\\\u0001\f\u000f\u0016tWM]5d\t\u0006$\u0018-\u0003\u0002sg\n)\u0011I\u001d:bs*\u0011\u0001/\u001c\u0005\u0006a\u0019\u0004\u001d!\r\u0005\u0006m\u001a\u0004\ra^\u0001\u0006m\u0006dW/\u001a\t\u0004%VC\bC\u0001-z\u0013\tQ\u0018L\u0001\u0005BeJ\f\u0017pU3r\u0011\u0015qf\r1\u0001`\u0011\u0015i\b\u0001\"\u0001\u007f\u0003\u00159(/\u001b;f)\u0015y\u00181AA\r)\rY\u0015\u0011\u0001\u0005\u0006aq\u0004\u001d!\r\u0005\u0007mr\u0004\r!!\u00021\t\u0005\u001d\u0011Q\u0002\t\u0005%V\u000bI\u0001\u0005\u0003\u0002\f\u00055A\u0002\u0001\u0003\r\u0003\u001f\t\u0019!!A\u0001\u0002\u000b\u0005\u0011\u0011\u0003\u0002\u0004?\u0012\n\u0014cAA\n\u0017B\u0019\u0011#!\u0006\n\u0007\u0005]!CA\u0004O_RD\u0017N\\4\t\u000byc\b\u0019A0\t\u000f\u0005u\u0001\u0001\"\u0015\u0002 \u0005aAm\\,sSR,g+\u00197vKR!\u0011\u0011EA\u0013)\r\u0011\u00151\u0005\u0005\u0007a\u0005m\u00019A\u0019\t\u000fY\fY\u00021\u0001\u0002(A\"\u0011\u0011FA\u0017!\u0011\u0011V+a\u000b\u0011\t\u0005-\u0011Q\u0006\u0003\r\u0003_\t)#!A\u0001\u0002\u000b\u0005\u0011\u0011\u0003\u0002\u0004?\u0012\u0012\u0004bBA\u001a\u0001\u0011\u0005\u0013QG\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0016\u0003-Cq!!\u000f\u0001\t\u0003\nY$\u0001\u0006eCR\fgi\u001c:nCR,\"!!\u0010\u0011\u000bE\ty$a\u0011\n\u0007\u0005\u0005#C\u0001\u0004PaRLwN\u001c\u0019\u0007\u0003\u000b\ny%!\u0016\u0011\u0011\u0005\u001d\u0013\u0011JA'\u0003'j\u0011\u0001B\u0005\u0004\u0003\u0017\"!A\u0003#bi\u00064uN]7biB!\u00111BA(\t1\t\t&a\u000e\u0002\u0002\u0003\u0005)\u0011AA\t\u0005\ryFe\r\t\u0005\u0003\u0017\t)\u0006\u0002\u0007\u0002X\u0005]\u0012\u0011!A\u0001\u0006\u0003\t\tBA\u0002`IQ:q!a\u0017\u0003\u0011\u0003\ti&\u0001\u0006BmJ|wK]5uKJ\u00042AKA0\r\u0019\t!\u0001#\u0001\u0002bM\u0019\u0011q\f\t\t\u000fa\ny\u0006\"\u0001\u0002fQ\u0011\u0011Q\f\u0005\t\u0003S\ny\u0006\"\u0001\u0002l\u0005)\u0011\r\u001d9msR1\u0011QNA9\u0003w\"2aOA8\u0011\u0019\u0001\u0014q\ra\u0002c!A\u00111OA4\u0001\u0004\t)(\u0001\u0002uaB\u0019q#a\u001e\n\u0007\u0005e\u0004D\u0001\bUCJ<W\r\u001e)s_ZLG-\u001a:\t\r\u001d\n9\u00071\u0001*\u0001")
public class AvroWriter
implements Writer {
    private final OutputStream os;
    private final AvroSettings settings;

    public static AvroWriter apply(TargetProvider targetProvider, AvroSettings avroSettings, EvaluationContext evaluationContext) {
        return AvroWriter$.MODULE$.apply(targetProvider, avroSettings, evaluationContext);
    }

    @Override
    public void startDocument(LocationCapable location) {
        Writer.startDocument$(this, location);
    }

    @Override
    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$(this, location, prefix, uri);
    }

    @Override
    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$(this, value, ctx);
    }

    @Override
    public String getName() {
        return Writer.getName$(this);
    }

    @Override
    public final void endDocument(LocationCapable location) {
        Writer.endDocument$(this, location);
    }

    @Override
    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$(this, location);
    }

    @Override
    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$(this, location, optionName, value);
    }

    @Override
    public AvroSettings settings() {
        return this.settings;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public Object writeObject(Value<ObjectSeq> v, Schema schema, EvaluationContext ctx) {
        GenericData.Record record;
        ObjectSeq objectSeq = v.evaluate(ctx);
        Schema.Type type = schema.getType();
        if (Schema.Type.MAP.equals(type)) {
            GenericData.Record map = new HashMap();
            objectSeq.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
                String name = ((QualifiedName)kvp._1().evaluate(ctx)).name();
                return map.put(name, this.write((Value<?>)kvp._2(), schema.getValueType(), ctx));
            });
            record = map;
        } else if (Schema.Type.RECORD.equals(type)) {
            GenericData.Record record2 = new GenericData.Record(schema);
            Schema.Field[] processedFields = new Schema.Field[schema.getFields().size()];
            objectSeq.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
                AvroWriter.$anonfun$writeObject$2(this, schema, ctx, record2, processedFields, kvp);
                return BoxedUnit.UNIT;
            });
            schema.getFields().forEach(missingField -> {
                if (processedFields[missingField.pos()] == null) {
                    if (missingField.defaultVal() != null) {
                        record2.put(missingField.pos(), missingField.defaultVal());
                    } else {
                        Schema fieldSchema = missingField.schema();
                        throw new MissingRequiredFieldException(missingField.name(), fieldSchema.getType().name().toLowerCase(), schema.getFullName(), v.location());
                    }
                }
            });
            record = record2;
        } else {
            throw new InvalidSchemaTypeException(type, (Seq<Schema.Type>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.RECORD, Schema.Type.MAP}))), v.location());
        }
        return record;
    }

    public GenericData.Array<Object> writeArray(Value<ArraySeq> value, Schema schema, EvaluationContext ctx) {
        Schema.Type type = schema.getType();
        if (!Schema.Type.ARRAY.equals(type)) {
            throw new InvalidSchemaTypeException(type, (Seq<Schema.Type>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.RECORD, Schema.Type.MAP}))), value.location());
        }
        Seq<Value<?>> evaluate = value.evaluate(ctx).toSeq();
        Schema elementType = schema.getElementType();
        GenericData.Array result = new GenericData.Array(evaluate.size(), schema);
        evaluate.foreach((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)result.add(this.write(v, elementType, ctx))));
        GenericData.Array array = result;
        return array;
    }

    public Object write(Value<?> value, Schema schema2, EvaluationContext ctx) {
        Object object;
        Type type = value.valueType(ctx);
        if (type.isInstanceOf(ObjectType$.MODULE$, ctx)) {
            object = this.writeObject(ObjectType$.MODULE$.coerce(value, ctx), schema2, ctx);
        } else if (type.isInstanceOf(ArrayType$.MODULE$, ctx)) {
            object = this.writeArray(ArrayType$.MODULE$.coerce(value, ctx), schema2, ctx);
        } else if (type.isInstanceOf(RangeType$.MODULE$, ctx)) {
            object = this.writeArray(ArrayType$.MODULE$.coerce(value, ctx), schema2, ctx);
        } else {
            Object object2;
            Schema.Type type2 = schema2.getType();
            if (Schema.Type.LONG.equals(type2)) {
                object2 = BoxesRunTime.boxToLong((long)((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toLong());
            } else if (Schema.Type.INT.equals(type2)) {
                object2 = BoxesRunTime.boxToInteger((int)((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toInt());
            } else if (Schema.Type.FLOAT.equals(type2)) {
                object2 = BoxesRunTime.boxToFloat((float)((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toFloat());
            } else if (Schema.Type.DOUBLE.equals(type2)) {
                object2 = BoxesRunTime.boxToDouble((double)((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toDouble());
            } else if (Schema.Type.BOOLEAN.equals(type2)) {
                object2 = BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            } else if (Schema.Type.STRING.equals(type2)) {
                object2 = StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            } else if (Schema.Type.BYTES.equals(type2)) {
                object2 = BinaryValue$.MODULE$.getBytes(BinaryType$.MODULE$.coerce(value, ctx), BinaryValue$.MODULE$.getBytes$default$2(), ctx);
            } else if (Schema.Type.ENUM.equals(type2)) {
                object2 = StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            } else if (Schema.Type.FIXED.equals(type2)) {
                object2 = StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            } else if (Schema.Type.NULL.equals(type2)) {
                object2 = NullType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            } else if (Schema.Type.UNION.equals(type2)) {
                Value<?> materializedValue = value.materialize(ctx);
                List types = schema2.getTypes();
                object2 = ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(types).asScala()).flatMap((Function1 & Serializable & scala.Serializable)schema -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.write(materializedValue, (Schema)schema, ctx)).toOption()), Buffer$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.write(materializedValue, (Schema)types.get(0), ctx));
            } else {
                throw new InvalidSchemaTypeException(type2, (Seq<Schema.Type>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.LONG, Schema.Type.INT, Schema.Type.FLOAT, Schema.Type.DOUBLE}))), value.location());
            }
            object = object2;
        }
        return object;
    }

    @Override
    public void doWriteValue(Value<?> value2, EvaluationContext ctx) {
        if (this.settings().schema() == null) {
            throw new MissingRequiredSettingException("schemaUrl", "Avro Writer", value2.location());
        }
        Schema schema = new Schema.Parser().parse(this.settings().schema());
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(schema, this.os);
        Type type = value2.valueType(ctx);
        if (type.isInstanceOf(ObjectType$.MODULE$, ctx)) {
            Object result = this.write(value2, schema, ctx);
            Object object = result;
            if (!(object instanceof GenericRecord)) {
                throw new InvalidSchemaTypeException(schema.getType(), (Seq<Schema.Type>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.RECORD}))), value2.location());
            }
            GenericRecord genericRecord = (GenericRecord)object;
            dataFileWriter.append((Object)genericRecord);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (type.isInstanceOf(ArrayType$.MODULE$, ctx)) {
            Iterator<Value<?>> iterator = ((ArraySeq)ArrayType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toIterator();
            iterator.foreach((Function1 & Serializable & scala.Serializable)value -> {
                AvroWriter.$anonfun$doWriteValue$1(this, ctx, schema, dataFileWriter, value);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)type);
        }
        dataFileWriter.flush();
        dataFileWriter.close();
    }

    @Override
    public Object result() {
        return this.os;
    }

    @Override
    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new AvroDataFormat());
    }

    public static final /* synthetic */ void $anonfun$writeObject$2(AvroWriter $this, Schema schema$1, EvaluationContext ctx$1, GenericData.Record record$1, Schema.Field[] processedFields$1, KeyValuePair kvp) {
        String name = ((QualifiedName)kvp._1().evaluate(ctx$1)).name();
        Schema.Field field = schema$1.getField(name);
        if (field == null) {
            throw new InvalidFieldNameException(name, (Seq<String>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema$1.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Buffer$.MODULE$.canBuildFrom())), kvp._1().location());
        }
        record$1.put(name, $this.write((Value<?>)kvp._2(), field.schema(), ctx$1));
        processedFields$1[field.pos()] = field;
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(AvroWriter $this, EvaluationContext ctx$4, Schema schema$2, DataFileWriter dataFileWriter$1, Value value) {
        Object result = $this.write(value, schema$2, ctx$4);
        Object object = result;
        if (!(object instanceof GenericRecord)) {
            throw new InvalidSchemaTypeException(schema$2.getType(), (Seq<Schema.Type>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.RECORD}))), value.location());
        }
        GenericRecord genericRecord = (GenericRecord)object;
        dataFileWriter$1.append((Object)genericRecord);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public AvroWriter(OutputStream os, AvroSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        ConfigurableReaderWriter.$init$(this);
        Writer.$init$(this);
    }
}

