/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ParentOnlyLookupStrategy;

public class MuleClassLoaderLookupPolicy
implements ClassLoaderLookupPolicy {
    private static final String PACKAGE_SEPARATOR = ".";
    private final Map<String, LookupStrategy> configuredLookupStrategies;
    private final Set<String> rootSystemPackages;
    private final Map<String, LookupStrategy> lookupStrategies;

    public MuleClassLoaderLookupPolicy(Map<String, LookupStrategy> lookupStrategies, Set<String> rootSystemPackages) {
        Preconditions.checkArgument(lookupStrategies != null, "Lookup strategies cannot be null");
        Preconditions.checkArgument(rootSystemPackages != null, "System packages cannot be null");
        this.rootSystemPackages = this.normalizeRootSystemPackages(rootSystemPackages);
        this.configuredLookupStrategies = this.normalizeLookupStrategies(lookupStrategies);
        this.lookupStrategies = new HashMap<String, LookupStrategy>(this.configuredLookupStrategies);
    }

    private Map<String, LookupStrategy> normalizeLookupStrategies(Map<String, LookupStrategy> lookupStrategies) {
        HashMap<String, LookupStrategy> result = new HashMap<String, LookupStrategy>();
        for (String packageName : lookupStrategies.keySet()) {
            result.put(this.normalizePackageName(packageName), lookupStrategies.get(packageName));
        }
        return result;
    }

    private void validateLookupPolicies(Map<String, LookupStrategy> lookupStrategies) {
        for (String packageName : lookupStrategies.keySet()) {
            if (!this.isSystemPackage(packageName) || lookupStrategies.get(packageName) instanceof ContainerOnlyLookupStrategy) continue;
            throw new IllegalArgumentException(MuleClassLoaderLookupPolicy.invalidLookupPolicyOverrideError(packageName, lookupStrategies.get(packageName)));
        }
    }

    protected static String invalidLookupPolicyOverrideError(String packageName, LookupStrategy lookupStrategy) {
        return "Attempt to override lookup strategy " + lookupStrategy.getClass().getSimpleName() + " for package: " + packageName;
    }

    private String normalizePackageName(String packageName) {
        if (packageName.endsWith(PACKAGE_SEPARATOR)) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }

    private Set<String> normalizeRootSystemPackages(Set<String> rootSystemPackages) {
        HashSet<String> result = new HashSet<String>();
        for (String systemPackage : rootSystemPackages) {
            if (!(systemPackage = systemPackage.trim()).endsWith(PACKAGE_SEPARATOR)) {
                systemPackage = systemPackage + PACKAGE_SEPARATOR;
            }
            result.add(systemPackage);
        }
        return result;
    }

    @Override
    public LookupStrategy getClassLookupStrategy(String className) {
        return this.getPackageLookupStrategy(ClassUtils.getPackageName((String)className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupStrategy getPackageLookupStrategy(String packageName) {
        LookupStrategy lookupStrategy = this.lookupStrategies.get(packageName);
        if (lookupStrategy == null) {
            MuleClassLoaderLookupPolicy muleClassLoaderLookupPolicy = this;
            synchronized (muleClassLoaderLookupPolicy) {
                lookupStrategy = this.lookupStrategies.get(packageName);
                if (lookupStrategy == null) {
                    lookupStrategy = this.isSystemPackage(packageName) ? ParentOnlyLookupStrategy.PARENT_ONLY : ChildFirstLookupStrategy.CHILD_FIRST;
                    this.lookupStrategies.put(packageName, lookupStrategy);
                }
            }
        }
        return lookupStrategy;
    }

    @Override
    public ClassLoaderLookupPolicy extend(Map<String, LookupStrategy> lookupStrategies) {
        return this.extend(lookupStrategies, false);
    }

    @Override
    public ClassLoaderLookupPolicy extend(Map<String, LookupStrategy> lookupStrategies, boolean overwrite) {
        this.validateLookupPolicies(lookupStrategies);
        HashMap<String, LookupStrategy> newLookupStrategies = new HashMap<String, LookupStrategy>(this.configuredLookupStrategies);
        for (String packageName : lookupStrategies.keySet()) {
            if (!overwrite && newLookupStrategies.containsKey(this.normalizePackageName(packageName))) continue;
            newLookupStrategies.put(packageName, lookupStrategies.get(packageName));
        }
        MuleClassLoaderLookupPolicy muleClassLoaderLookupPolicy = new MuleClassLoaderLookupPolicy(newLookupStrategies, this.rootSystemPackages);
        return muleClassLoaderLookupPolicy;
    }

    private boolean isSystemPackage(String packageName) {
        return this.rootSystemPackages.contains(packageName + PACKAGE_SEPARATOR) || this.rootSystemPackages.contains(packageName);
    }
}

