/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.DeclaresExternalLibraries;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.ExternalLibs;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;
import org.mule.runtime.extension.api.annotation.license.RequiresEntitlement;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.ModelLoaderDelegate;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.api.loader.java.type.WithParameters;
import org.mule.runtime.module.extension.internal.loader.java.ConfigModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ConnectionProviderModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.FunctionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.ParameterModelsLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.SourceModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureFieldContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.StackableTypesParameterContributor;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;

public class DefaultJavaModelLoaderDelegate
implements ModelLoaderDelegate {
    protected Class<?> extensionType;
    protected final ExtensionElement extensionElement;
    protected final ClassTypeLoader typeLoader;
    protected final String version;
    private final ConfigModelLoaderDelegate configLoaderDelegate = new ConfigModelLoaderDelegate(this);
    private final OperationModelLoaderDelegate operationLoaderDelegate = new OperationModelLoaderDelegate(this);
    private final FunctionModelLoaderDelegate functionModelLoaderDelegate = new FunctionModelLoaderDelegate(this);
    private final SourceModelLoaderDelegate sourceModelLoaderDelegate = new SourceModelLoaderDelegate(this);
    private final ConnectionProviderModelLoaderDelegate connectionProviderModelLoaderDelegate = new ConnectionProviderModelLoaderDelegate(this);
    private final ParameterModelsLoaderDelegate fieldParametersLoader;
    private final ParameterModelsLoaderDelegate methodParametersLoader;

    public DefaultJavaModelLoaderDelegate(ExtensionElement extensionElement, String version) {
        this.version = version;
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(Thread.currentThread().getContextClassLoader());
        this.extensionElement = extensionElement;
        this.fieldParametersLoader = new ParameterModelsLoaderDelegate((List<ParameterDeclarerContributor>)this.getParameterFieldsContributors(), this.typeLoader);
        this.methodParametersLoader = new ParameterModelsLoaderDelegate(this.getParameterMethodsContributors(), this.typeLoader);
    }

    private List<ParameterDeclarerContributor> getParameterMethodsContributors() {
        return ImmutableList.of((Object)StackableTypesParameterContributor.defaultContributor(this.typeLoader));
    }

    private ImmutableList<ParameterDeclarerContributor> getParameterFieldsContributors() {
        return ImmutableList.of((Object)new InfrastructureFieldContributor(), (Object)StackableTypesParameterContributor.defaultContributor(this.typeLoader));
    }

    public DefaultJavaModelLoaderDelegate(Class<?> extensionType, String version) {
        this(new ExtensionTypeWrapper(extensionType, ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(extensionType.getClassLoader())), version);
        this.extensionType = extensionType;
    }

    @Override
    public ExtensionDeclarer declare(ExtensionLoadingContext context) {
        ExtensionDeclarer declarer = context.getExtensionDeclarer().named(this.extensionElement.getName()).onVersion(this.version).fromVendor(this.extensionElement.getVendor()).withCategory(this.extensionElement.getCategory()).withModelProperty(new ExtensionTypeDescriptorModelProperty(this.extensionElement));
        context.getParameter("COMPILATION_MODE").ifPresent(m -> declarer.withModelProperty(new CompileTimeModelProperty()));
        this.extensionElement.getDeclaringClass().ifPresent(extensionClass -> declarer.withModelProperty(new ImplementingTypeModelProperty((Class<?>)extensionClass)));
        this.processLicenseRequirements(declarer);
        this.parseExternalLibs(this.extensionElement, declarer);
        this.addExceptionEnricher(this.extensionElement, declarer);
        this.configLoaderDelegate.declareConfigurations(declarer, this.extensionElement);
        this.connectionProviderModelLoaderDelegate.declareConnectionProviders(declarer, this.extensionElement);
        if (!CollectionUtils.isEmpty(this.extensionElement.getConfigurations())) {
            this.operationLoaderDelegate.declareOperations(declarer, declarer, null, this.extensionElement.getOperations(), false);
            this.functionModelLoaderDelegate.declareFunctions(declarer, declarer, null, this.extensionElement.getFunctions());
            this.extensionElement.getSources().forEach(source -> this.sourceModelLoaderDelegate.declareMessageSource(declarer, declarer, (SourceElement)source, false));
        }
        return declarer;
    }

    private void processLicenseRequirements(ExtensionDeclarer declarer) {
        Optional<RequiresEntitlement> requiresEntitlementOptional = this.extensionElement.getAnnotation(RequiresEntitlement.class);
        Optional<RequiresEnterpriseLicense> requiresEnterpriseLicenseOptional = this.extensionElement.getAnnotation(RequiresEnterpriseLicense.class);
        boolean requiresEnterpriseLicense = requiresEnterpriseLicenseOptional.isPresent();
        boolean allowsEvaluationLicense = requiresEnterpriseLicenseOptional.map(RequiresEnterpriseLicense::allowEvaluationLicense).orElse(true);
        Optional<String> requiredEntitlement = requiresEntitlementOptional.map(RequiresEntitlement::name);
        declarer.withModelProperty(new LicenseModelProperty(requiresEnterpriseLicense, allowsEvaluationLicense, requiredEntitlement));
    }

    void parseExternalLibs(WithAnnotations withAnnotations, DeclaresExternalLibraries declarer) {
        Optional<ExternalLibs> externalLibs = withAnnotations.getAnnotation(ExternalLibs.class);
        if (externalLibs.isPresent()) {
            Arrays.stream(externalLibs.get().value()).forEach(lib -> this.parseExternalLib(declarer, (ExternalLib)lib));
        } else {
            withAnnotations.getAnnotation(ExternalLib.class).ifPresent(lib -> this.parseExternalLib(declarer, (ExternalLib)lib));
        }
    }

    private void parseExternalLib(DeclaresExternalLibraries declarer, ExternalLib externalLibAnnotation) {
        ExternalLibraryModel.ExternalLibraryModelBuilder builder = ExternalLibraryModel.builder().withName(externalLibAnnotation.name()).withDescription(externalLibAnnotation.description()).withType(externalLibAnnotation.type()).isOptional(externalLibAnnotation.optional());
        StringUtils.ifNotBlank(externalLibAnnotation.nameRegexpMatcher(), builder::withRegexpMatcher);
        StringUtils.ifNotBlank(externalLibAnnotation.requiredClassName(), builder::withRequiredClassName);
        StringUtils.ifNotBlank(externalLibAnnotation.coordinates(), builder::withCoordinates);
        declarer.withExternalLibrary(builder.build());
    }

    <M extends WithAnnotations> HasModelProperties addExceptionEnricher(M model, HasModelProperties declarer) {
        MuleExtensionAnnotationParser.getExceptionEnricherFactory(model).map(ExceptionHandlerModelProperty::new).ifPresent(declarer::withModelProperty);
        return declarer;
    }

    boolean isInvalidConfigSupport(boolean supportsConfig, Optional<ExtensionParameter> ... parameters) {
        return !supportsConfig && Stream.of(parameters).anyMatch(Optional::isPresent);
    }

    Declarer selectDeclarerBasedOnConfig(ExtensionDeclarer extensionDeclarer, Declarer declarer, Optional<ExtensionParameter> ... parameters) {
        for (Optional<ExtensionParameter> parameter : parameters) {
            if (!parameter.isPresent()) continue;
            return declarer;
        }
        return extensionDeclarer;
    }

    Optional<ExtensionParameter> getConfigParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(Config.class).stream().findFirst();
    }

    Optional<ExtensionParameter> getConnectionParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(Connection.class).stream().findFirst();
    }

    ConfigModelLoaderDelegate getConfigLoaderDelegate() {
        return this.configLoaderDelegate;
    }

    OperationModelLoaderDelegate getOperationLoaderDelegate() {
        return this.operationLoaderDelegate;
    }

    FunctionModelLoaderDelegate getFunctionModelLoaderDelegate() {
        return this.functionModelLoaderDelegate;
    }

    SourceModelLoaderDelegate getSourceModelLoaderDelegate() {
        return this.sourceModelLoaderDelegate;
    }

    ConnectionProviderModelLoaderDelegate getConnectionProviderModelLoaderDelegate() {
        return this.connectionProviderModelLoaderDelegate;
    }

    ClassTypeLoader getTypeLoader() {
        return this.typeLoader;
    }

    Class<?> getExtensionType() {
        return this.extensionElement.getDeclaringClass().orElse(null);
    }

    ExtensionElement getExtensionElement() {
        return this.extensionElement;
    }

    protected ParameterModelsLoaderDelegate getFieldParametersLoader() {
        return this.fieldParametersLoader;
    }

    protected ParameterModelsLoaderDelegate getMethodParametersLoader() {
        return this.methodParametersLoader;
    }
}

