/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import java.lang.reflect.Field;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.UpdatingClientCredentialsState;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class ClientCredentialsConnectionProviderWrapper<C>
extends OAuthConnectionProviderWrapper<C> {
    private final ClientCredentialsConfig oauthConfig;
    private final ClientCredentialsOAuthHandler oauthHandler;
    private final FieldSetter<ConnectionProvider<C>, ClientCredentialsState> oauthStateSetter;
    private final Once.RunOnce dance;
    private ClientCredentialsOAuthDancer dancer;

    public ClientCredentialsConnectionProviderWrapper(ConnectionProvider<C> delegate, ClientCredentialsConfig oauthConfig, Map<Field, String> callbackValues, ClientCredentialsOAuthHandler oauthHandler, ReconnectionConfig reconnectionConfig) {
        super(delegate, reconnectionConfig, callbackValues);
        this.oauthConfig = oauthConfig;
        this.oauthHandler = oauthHandler;
        this.oauthStateSetter = this.getOAuthStateSetter(delegate, ClientCredentialsState.class, "Client Credentials");
        this.dance = Once.of(this::updateOAuthState);
    }

    @Override
    public C connect() throws ConnectionException {
        this.dance.runOnce();
        return super.connect();
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        try {
            ResourceOwnerOAuthContext context = this.getContext();
            if (context.getAccessToken() != null) {
                return this.getDelegate().validate(connection);
            }
            String message = "Server did not granted an access token";
            return ConnectionValidationResult.failure(message, new IllegalStateException(message));
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure("Could not obtain an access token", e);
        }
    }

    @Override
    public void refreshToken(String resourceOwnerId) {
        this.oauthHandler.refreshToken(this.oauthConfig);
    }

    @Override
    public void invalidate(String resourceOwnerId) {
        this.oauthHandler.invalidate(this.oauthConfig);
    }

    @Override
    public OAuthGrantType getGrantType() {
        return this.oauthConfig.getGrantType();
    }

    private void updateOAuthState() {
        ConnectionProvider delegate = this.getDelegate();
        ResourceOwnerOAuthContext context = this.getContext();
        this.oauthStateSetter.set(delegate, new UpdatingClientCredentialsState(this.dancer, context, updatedContext -> this.updateOAuthParameters(delegate, (ResourceOwnerOAuthContext)updatedContext)));
        this.updateOAuthParameters(delegate, context);
    }

    private ResourceOwnerOAuthContext getContext() {
        return this.oauthHandler.getOAuthContext(this.oauthConfig);
    }

    @Override
    public void start() throws MuleException {
        this.dancer = this.oauthHandler.register(this.oauthConfig);
        super.start();
    }
}

