/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.BaseEventDecorator;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public final class EventQuickCopy {
    private EventQuickCopy() {
    }

    public static CoreEvent quickCopy(EventContext context, CoreEvent event) {
        if (event instanceof EventQuickCopyContextDecorator && ((EventQuickCopyContextDecorator)event).getEvent().getContext() == context) {
            return ((EventQuickCopyContextDecorator)event).getEvent();
        }
        return event instanceof InternalEvent && context instanceof BaseEventContext ? new EventQuickCopyContextDecorator((BaseEventContext)context, (InternalEvent)event) : CoreEvent.builder(context, event).build();
    }

    public static PrivilegedEvent quickCopy(EventContext context, PrivilegedEvent event) {
        if (event instanceof EventQuickCopyContextDecorator && ((EventQuickCopyContextDecorator)event).getEvent().getContext() == context) {
            return ((EventQuickCopyContextDecorator)event).getEvent();
        }
        return event instanceof InternalEvent && context instanceof BaseEventContext ? new EventQuickCopyContextDecorator((BaseEventContext)context, (InternalEvent)event) : PrivilegedEvent.builder(context, event).build();
    }

    public static InternalEvent quickCopy(CoreEvent event, Map<String, Object> internalParameters) {
        if (event instanceof EventQuickCopyInternalParametersDecorator) {
            EventQuickCopyInternalParametersDecorator quickCopy = (EventQuickCopyInternalParametersDecorator)event;
            HashMap<String, Object> resolvedParams = new HashMap<String, Object>(2 * (quickCopy.internalParameters.size() + internalParameters.size()));
            resolvedParams.putAll(quickCopy.internalParameters);
            resolvedParams.putAll(internalParameters);
            return EventQuickCopy.quickCopy(quickCopy.getEvent(), resolvedParams);
        }
        return event instanceof InternalEvent ? new EventQuickCopyInternalParametersDecorator((InternalEvent)event, internalParameters) : InternalEvent.builder(event).internalParameters(internalParameters).build();
    }

    private static class EventQuickCopyInternalParametersDecorator
    extends BaseEventDecorator {
        private static final long serialVersionUID = -8748877786435182694L;
        private final Map<String, Object> internalParameters;

        public EventQuickCopyInternalParametersDecorator(InternalEvent event, Map<String, Object> internalParameters) {
            super(event);
            this.internalParameters = Collections.unmodifiableMap(internalParameters);
        }

        @Override
        public Map<String, ?> getInternalParameters() {
            if (this.getEvent().getInternalParameters().isEmpty()) {
                return this.internalParameters;
            }
            HashMap<String, Object> resolvedParams = new HashMap<String, Object>(2 * (this.getEvent().getInternalParameters().size() + this.internalParameters.size()));
            resolvedParams.putAll(this.getEvent().getInternalParameters());
            resolvedParams.putAll(this.internalParameters);
            return resolvedParams;
        }

        @Override
        public <T> T getInternalParameter(String key) {
            Object outerValue = this.internalParameters.get(key);
            return (T)(outerValue != null ? outerValue : this.getEvent().getInternalParameter(key));
        }
    }

    private static class EventQuickCopyContextDecorator
    extends BaseEventDecorator {
        private static final long serialVersionUID = -2674520914985642327L;
        private final BaseEventContext context;

        public EventQuickCopyContextDecorator(BaseEventContext context, InternalEvent event) {
            super(event);
            this.context = context;
        }

        @Override
        public BaseEventContext getContext() {
            return this.context;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.context.getFlowCallStack();
        }

        @Override
        public String getCorrelationId() {
            return this.getLegacyCorrelationId() != null ? this.getLegacyCorrelationId() : this.getContext().getCorrelationId();
        }
    }
}

