/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.internal.execution.NotificationFunction;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ModuleFlowProcessingTemplate
implements ModuleFlowProcessingPhaseTemplate {
    private final Processor messageProcessor;
    private final List<NotificationFunction> notificationFunctions;

    protected ModuleFlowProcessingTemplate(Processor messageProcessor, List<NotificationFunction> notificationFunctions) {
        this.messageProcessor = messageProcessor;
        this.notificationFunctions = notificationFunctions;
    }

    @Override
    public CheckedFunction<CoreEvent, Map<String, Object>> getSuccessfulExecutionResponseParametersFunction() {
        return event -> Collections.emptyMap();
    }

    @Override
    public CheckedFunction<CoreEvent, Map<String, Object>> getFailedExecutionResponseParametersFunction() {
        return event -> Collections.emptyMap();
    }

    @Override
    public SourceResultAdapter getSourceMessage() {
        return new SourceResultAdapter(Result.builder().build(), null, MediaType.ANY, false, Optional.empty(), null);
    }

    @Override
    public List<NotificationFunction> getNotificationFunctions() {
        return this.notificationFunctions;
    }

    @Override
    public CoreEvent routeEvent(CoreEvent muleEvent) throws MuleException {
        return this.messageProcessor.process(muleEvent);
    }

    @Override
    public Publisher<CoreEvent> routeEventAsync(CoreEvent event) {
        return Mono.just((Object)event).transform((Function)this.messageProcessor);
    }

    @Override
    public Publisher<CoreEvent> routeEventAsync(Publisher<CoreEvent> eventPub) {
        return Flux.from(eventPub).transform((Function)this.messageProcessor);
    }

    @Override
    public Publisher<Void> sendResponseToClient(CoreEvent response, Map<String, Object> parameters) {
        return Mono.empty();
    }

    @Override
    public Publisher<Void> sendFailureResponseToClient(MessagingException messagingException, Map<String, Object> parameters) {
        return Mono.empty();
    }

    @Override
    public void afterPhaseExecution(Either<MessagingException, CoreEvent> either) {
    }
}

