/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.ErrorHandlerNotification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.DisjunctiveErrorTypeMatcher;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.exception.AbstractExceptionListener;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@NoExtend
public abstract class TemplateOnErrorHandler
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private static final Pattern ERROR_HANDLER_LOCATION_PATTERN = Pattern.compile(".*/.*/.*");
    @Inject
    protected ConfigurationComponentLocator locator;
    @Inject
    private ConfigurationProperties configurationProperties;
    protected Optional<Location> flowLocation = Optional.empty();
    private MessageProcessorChain configuredMessageProcessors;
    protected String when;
    protected boolean handleException;
    protected String errorType = null;
    protected ErrorTypeMatcher errorTypeMatcher = null;
    private String errorHandlerLocation;
    private boolean isLocalErrorHandlerLocation;
    private ComponentLocation location;

    @Override
    public final CoreEvent handleException(Exception exception, CoreEvent event) {
        try {
            return (CoreEvent)Mono.from(this.applyInternal(exception, event)).block();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(Exceptions.unwrap(throwable));
        }
    }

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        return this.applyInternal(exception, ((MessagingException)exception).getEvent());
    }

    private Publisher<CoreEvent> applyInternal(Exception exception, CoreEvent event) {
        return Mono.just((Object)event).map(this.beforeRouting(exception)).flatMapMany(this.route(exception)).last().map(this.afterRouting()).doOnError(MessagingException.class, this.onRoutingError()).handle((result, sink) -> {
            if (exception instanceof MessagingException) {
                MessagingException messagingEx = (MessagingException)exception;
                if (messagingEx.handled()) {
                    sink.next(result);
                } else {
                    if (messagingEx.getEvent() != result) {
                        messagingEx.setProcessedEvent((CoreEvent)result);
                    }
                    sink.error((Throwable)exception);
                }
            } else {
                sink.error((Throwable)exception);
            }
        }).doOnSuccessOrError((result, throwable) -> this.fireEndNotification(event, (CoreEvent)result, (Throwable)throwable));
    }

    private Consumer<MessagingException> onRoutingError() {
        return me -> {
            try {
                this.logger.error("Exception during exception strategy execution");
                this.resolveAndLogException((Throwable)me);
                if (this.isOwnedTransaction()) {
                    this.rollback((Exception)me);
                }
            }
            catch (Exception ex) {
                this.logger.warn(ex.getMessage());
            }
        };
    }

    private void fireEndNotification(CoreEvent event, CoreEvent result, Throwable throwable) {
        this.notificationFirer.dispatch(new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo(result != null ? result : event, throwable instanceof MessagingException ? (MessagingException)throwable : null, this.configuredMessageProcessors), this.location, 2002));
    }

    protected Function<CoreEvent, Publisher<CoreEvent>> route(Exception exception) {
        return event -> {
            if (this.getMessageProcessors().isEmpty()) {
                return Mono.just((Object)event);
            }
            event = CoreEvent.builder(event).message(InternalMessage.builder(event.getMessage()).exceptionPayload(new DefaultExceptionPayload(exception)).build()).build();
            return Mono.from(MessageProcessors.processWithChildContextDontComplete(event, this.configuredMessageProcessors, Optional.ofNullable(this.location), NullExceptionHandler.getInstance()));
        };
    }

    @Override
    public void setMessageProcessors(List<Processor> processors) {
        super.setMessageProcessors(processors);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.configuredMessageProcessors == null ? new ArrayList() : Collections.singletonList(this.configuredMessageProcessors);
    }

    private void markExceptionAsHandledIfRequired(Exception exception) {
        if (this.handleException) {
            this.markExceptionAsHandled(exception);
        }
    }

    protected void markExceptionAsHandled(Exception exception) {
        if (exception instanceof MessagingException) {
            ((MessagingException)exception).setHandled(true);
        }
    }

    protected CoreEvent nullifyExceptionPayloadIfRequired(CoreEvent event) {
        if (this.handleException) {
            return CoreEvent.builder(event).error(null).message(InternalMessage.builder(event.getMessage()).exceptionPayload(null).build()).build();
        }
        return event;
    }

    private void processStatistics() {
        if (this.statistics != null && this.statistics.isEnabled()) {
            this.statistics.incExecutionError();
        }
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        this.location = this.getLocation();
        Optional<ProcessingStrategy> processingStrategy = Optional.empty();
        if (this.flowLocation.isPresent()) {
            processingStrategy = MessageProcessors.getProcessingStrategy(this.locator, this.flowLocation.get());
        } else if (this.location != null) {
            processingStrategy = MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation());
        }
        this.configuredMessageProcessors = MessageProcessors.newChain(processingStrategy, this.getMessageProcessors());
        if (this.configuredMessageProcessors != null) {
            this.configuredMessageProcessors.setMuleContext(muleContext);
        }
        this.errorTypeMatcher = TemplateOnErrorHandler.createErrorType(muleContext.getErrorTypeRepository(), this.errorType, this.configurationProperties);
        if (!this.inDefaultErrorHandler()) {
            this.errorHandlerLocation = this.location.getLocation();
            this.isLocalErrorHandlerLocation = ERROR_HANDLER_LOCATION_PATTERN.matcher(this.errorHandlerLocation).find();
            if (this.isLocalErrorHandlerLocation) {
                this.errorHandlerLocation = this.errorHandlerLocation.substring(0, this.errorHandlerLocation.lastIndexOf(47));
                this.errorHandlerLocation = this.errorHandlerLocation.substring(0, this.errorHandlerLocation.lastIndexOf(47));
            }
        }
    }

    public static ErrorTypeMatcher createErrorType(ErrorTypeRepository errorTypeRepository, String errorTypeNames, ConfigurationProperties configurationProperties) {
        if (errorTypeNames == null) {
            return null;
        }
        String[] errorTypeIdentifiers = errorTypeNames.split(",");
        List<ErrorTypeMatcher> matchers = Arrays.stream(errorTypeIdentifiers).map(identifier -> {
            String parsedIdentifier = identifier.trim();
            ComponentIdentifier errorTypeComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation(parsedIdentifier);
            return new SingleErrorTypeMatcher(errorTypeRepository.lookupErrorType(errorTypeComponentIdentifier).orElseGet(() -> {
                if (configurationProperties.resolveBooleanProperty("mule.application.deployment.lazyInit").orElse(false).booleanValue()) {
                    return errorTypeRepository.addErrorType(errorTypeComponentIdentifier, errorTypeRepository.getAnyErrorType());
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not find ErrorType for the given identifier: '%s'", parsedIdentifier));
            }));
        }).collect(Collectors.toList());
        return new DisjunctiveErrorTypeMatcher(matchers);
    }

    @Deprecated
    public static ErrorTypeMatcher createErrorType(ErrorTypeRepository errorTypeRepository, String errorTypeNames) {
        return TemplateOnErrorHandler.createErrorType(errorTypeRepository, errorTypeNames, new ConfigurationProperties(){

            @Override
            public <T> Optional<T> resolveProperty(String propertyKey) {
                return Optional.empty();
            }

            @Override
            public Optional<Boolean> resolveBooleanProperty(String property) {
                return Optional.empty();
            }

            @Override
            public Optional<String> resolveStringProperty(String property) {
                return Optional.empty();
            }
        });
    }

    public void setWhen(String when) {
        this.when = when;
    }

    @Override
    public boolean accept(CoreEvent event) {
        return this.acceptsAll() || this.acceptsErrorType(event) || this.when != null && this.muleContext.getExpressionManager().evaluateBoolean(this.when, event, this.location);
    }

    private boolean acceptsErrorType(CoreEvent event) {
        return this.errorTypeMatcher != null && this.errorTypeMatcher.match(event.getError().get().getErrorType());
    }

    protected Function<CoreEvent, CoreEvent> afterRouting() {
        return event -> {
            if (event != null) {
                return this.nullifyExceptionPayloadIfRequired((CoreEvent)event);
            }
            return event;
        };
    }

    protected Function<CoreEvent, CoreEvent> beforeRouting(Exception exception) {
        return event -> {
            this.notificationFirer.dispatch(new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo(event, exception, this.configuredMessageProcessors), this.location, 2001));
            this.fireNotification(exception, (CoreEvent)event);
            this.logException(exception, (CoreEvent)event);
            this.processStatistics();
            this.markExceptionAsHandledIfRequired(exception);
            return event;
        };
    }

    protected void logException(Throwable t, CoreEvent event) {
        if (Boolean.TRUE.toString().equals(this.logException) || this.muleContext.getExpressionManager().evaluateBoolean(this.logException, event, this.location, true, true)) {
            this.resolveAndLogException(t);
        }
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public void setRootContainerName(String rootContainerName) {
        ComponentAnnotations.updateRootContainerName(rootContainerName, this);
    }

    protected void setFlowLocation(Location location) {
        this.flowLocation = Optional.ofNullable(location);
    }

    public abstract TemplateOnErrorHandler duplicateFor(Location var1);

    private boolean isTransactionInGlobalErrorHandler(TransactionAdapter transaction) {
        String transactionContainerName = transaction.getComponentLocation().get().getRootContainerName();
        return this.flowLocation.isPresent() && transactionContainerName.equals(this.flowLocation.get().getGlobalName());
    }

    protected boolean isOwnedTransaction() {
        TransactionAdapter transaction = (TransactionAdapter)TransactionCoordination.getInstance().getTransaction();
        if (transaction == null || !transaction.getComponentLocation().isPresent()) {
            return false;
        }
        if (this.inDefaultErrorHandler()) {
            return this.defaultErrorHandlerOwnsTransaction(transaction);
        }
        if (this.isTransactionInGlobalErrorHandler(transaction)) {
            return true;
        }
        if (this.flowLocation.isPresent()) {
            return false;
        }
        if (!this.isLocalErrorHandlerLocation) {
            return this.sameRootContainerLocation(transaction);
        }
        String transactionLocation = transaction.getComponentLocation().get().getLocation();
        return this.sameRootContainerLocation(transaction) && this.errorHandlerLocation.equals(transactionLocation);
    }

    private boolean sameRootContainerLocation(TransactionAdapter transaction) {
        String transactionContainerName = transaction.getComponentLocation().get().getRootContainerName();
        return transactionContainerName.equals(this.getRootContainerLocation().getGlobalName());
    }

    private boolean inDefaultErrorHandler() {
        return this.location == null;
    }

    private boolean defaultErrorHandlerOwnsTransaction(TransactionAdapter transaction) {
        String transactionLocation = transaction.getComponentLocation().get().getLocation();
        if (this.flowLocation.isPresent()) {
            return transactionLocation.equals(this.flowLocation.get().toString());
        }
        return this.sameRootContainerLocation(transaction);
    }
}

