/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.core.functions;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.RuntimeConfigProperties$;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.AdditionalServicesProvider;
import org.mule.weave.v2.model.DefaultEvaluationContext;
import org.mule.weave.v2.model.DefaultEvaluationContext$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.ServiceManager$;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatManager$;
import org.mule.weave.v2.module.option.Settings;
import org.mule.weave.v2.module.reader.AutoPersistedOutputStream;
import org.mule.weave.v2.module.reader.ResourceManager;
import org.mule.weave.v2.module.writer.ConfigurableEncoding;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import org.mule.weave.v2.utils.StringHelper$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

public final class WriteFunctionValue$ {
    public static WriteFunctionValue$ MODULE$;
    private final String DATA_WEAVE_MIMETYPE;
    private final Integer maxValueLength;

    static {
        new WriteFunctionValue$();
    }

    public String DATA_WEAVE_MIMETYPE() {
        return this.DATA_WEAVE_MIMETYPE;
    }

    public Integer maxValueLength() {
        return this.maxValueLength;
    }

    private Either<String, byte[]> processResult(InputStream stream, String charset) {
        Left left;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(stream, charset);){
            try {
                left = package$.MODULE$.Left().apply((Object)source.mkString());
            }
            catch (MalformedInputException x) {
                byte[] byArray;
                Right$ right$ = package$.MODULE$.Right();
                InputStream inputStream = stream;
                if (inputStream instanceof SeekableStream) {
                    SeekableStream seekableStream = (SeekableStream)((Object)inputStream);
                    byArray = BinaryValue$.MODULE$.getBytesFromSeekableStream(seekableStream, BinaryValue$.MODULE$.getBytesFromSeekableStream$default$2());
                } else {
                    byArray = BinaryValue$.MODULE$.getBytesFromInputStream(stream, BinaryValue$.MODULE$.getBytesFromInputStream$default$2());
                }
                left = right$.apply((Object)byArray);
            }
        }
        return left;
    }

    public Either<String, byte[]> write(Value<?> value, Writer writer, DataFormat<?, ?> dataFormat, LocationCapable location, EvaluationContext parentContext) {
        LoggingService x$9 = parentContext.serviceManager().loggingService();
        AdditionalServicesProvider x$10 = parentContext.serviceManager().customService();
        ResourceManager x$11 = ServiceManager$.MODULE$.$lessinit$greater$default$2();
        ServiceManager manager = new ServiceManager(x$9, x$11, x$10);
        boolean x$12 = parentContext.closeAfterExecution();
        ServiceManager x$13 = manager;
        boolean x$14 = DefaultEvaluationContext$.MODULE$.apply$default$1();
        boolean x$15 = DefaultEvaluationContext$.MODULE$.apply$default$4();
        DefaultEvaluationContext childExecutionContext = new DefaultEvaluationContext(x$14, x$13, x$12, x$15);
        return this.org$mule$weave$v2$core$functions$WriteFunctionValue$$writeUsingContext(value, writer, dataFormat, location, childExecutionContext);
    }

    public LocationCapable write$default$4() {
        return UnknownLocationCapable$.MODULE$;
    }

    public Either<String, byte[]> org$mule$weave$v2$core$functions$WriteFunctionValue$$writeUsingContext(Value<?> value, Writer writer, DataFormat<?, ?> dataFormat, LocationCapable location, DefaultEvaluationContext childExecutionContext) {
        Left left;
        Charset charset;
        try {
            writer.startDocument(location);
            writer.writeValue(value, childExecutionContext);
            writer.endDocument(location);
        }
        finally {
            childExecutionContext.close();
        }
        Settings settings = writer.settings();
        if (settings instanceof ConfigurableEncoding) {
            ConfigurableEncoding configurableEncoding = (ConfigurableEncoding)settings;
            charset = configurableEncoding.charset(childExecutionContext);
        } else {
            charset = (Charset)dataFormat.defaultCharset().getOrElse((Function0 & Serializable & scala.Serializable)() -> childExecutionContext.serviceManager().charsetProviderService().defaultCharset());
        }
        Charset charset2 = charset;
        Object object = writer.result();
        if (object instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)object;
            left = package$.MODULE$.Right().apply((Object)byteArrayOutputStream.toByteArray());
        } else if (object instanceof AutoPersistedOutputStream) {
            AutoPersistedOutputStream autoPersistedOutputStream = (AutoPersistedOutputStream)object;
            left = this.processResult((InputStream)((Object)autoPersistedOutputStream.toInputStream()), charset2.name());
        } else if (object instanceof SeekableStream) {
            SeekableStream seekableStream = (SeekableStream)object;
            left = this.processResult((InputStream)((Object)seekableStream), charset2.name());
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            left = this.processResult(inputStream, charset2.name());
        } else if (object instanceof Object) {
            Object object2 = object;
            left = package$.MODULE$.Left().apply((Object)String.valueOf(object2));
        } else if (object == null) {
            left = package$.MODULE$.Left().apply((Object)"null");
        } else {
            throw new MatchError(object);
        }
        Left result = left;
        return result;
    }

    public String toDwString(Value<?> value, int maxLength, EvaluationContext ctx) {
        return StringHelper$.MODULE$.abbreviate(this.toDwString(value, ctx), maxLength);
    }

    public String toDwString(Value<?> value, EvaluationContext ctx) {
        String string;
        try {
            String string2;
            Option<DataFormat<?, ?>> maybeFormat;
            Option<DataFormat<?, ?>> option = maybeFormat = DataFormatManager$.MODULE$.byContentType("application/dw", ctx);
            if (None$.MODULE$.equals(option)) {
                string2 = String.valueOf(value.evaluate(ctx));
            } else if (option instanceof Some) {
                String string3;
                Either<String, byte[]> result;
                Some some = (Some)option;
                DataFormat dataFormat = (DataFormat)some.value();
                Writer writer = dataFormat.writer((Option<Object>)None$.MODULE$, dataFormat.writer$default$2(), ctx);
                writer.setOption(UnknownLocation$.MODULE$, "indent", "");
                Either<String, byte[]> either = result = this.write(value, writer, dataFormat, value, ctx);
                if (either instanceof Left) {
                    String str;
                    Left left = (Left)either;
                    string3 = str = (String)left.value();
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    byte[] bytes = (byte[])right.value();
                    string3 = new String(bytes, StandardCharsets.UTF_8);
                } else {
                    throw new MatchError(either);
                }
                string2 = string3;
            } else {
                throw new MatchError(option);
            }
            string = string2;
        }
        catch (Exception e) {
            String result = String.valueOf(value.evaluate(ctx));
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String message = new StringBuilder(73).append("Unexpected error while trying with valueType `").append(value.valueType(ctx)).append("` and value : `").append(result).append("`. Reason :\n").append(writer.toString()).toString();
            Predef$.MODULE$.println((Object)message);
            ctx.serviceManager().loggingService().logError(message);
            string = result;
        }
        return string;
    }

    private WriteFunctionValue$() {
        MODULE$ = this;
        this.DATA_WEAVE_MIMETYPE = "application/dw";
        this.maxValueLength = RuntimeConfigProperties$.MODULE$.MAX_STRING_VALUE_MESSAGE_LENGTH();
    }
}

