/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.exception.MessageRedeliveredException;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class OnErrorPropagateHandler
extends TemplateOnErrorHandler {
    @Override
    public boolean acceptsAll() {
        return this.errorTypeMatcher == null && this.when == null;
    }

    boolean acceptsErrorType(ErrorType errorType) {
        return this.acceptsAll() || this.errorTypeMatcher != null && this.errorTypeMatcher.match(errorType);
    }

    @Override
    protected Function<CoreEvent, CoreEvent> beforeRouting(Exception exception) {
        return event -> {
            event = super.beforeRouting(exception).apply((CoreEvent)event);
            if (!this.isRedeliveryExhausted(exception) && this.isOwnedTransaction()) {
                this.rollback(exception);
            }
            return event;
        };
    }

    @Override
    public TemplateOnErrorHandler duplicateFor(Location buildFor) {
        OnErrorPropagateHandler cpy = new OnErrorPropagateHandler();
        cpy.setFlowLocation(buildFor);
        cpy.setWhen(this.when);
        cpy.setHandleException(this.handleException);
        cpy.setErrorType(this.errorType);
        cpy.setMessageProcessors(this.getMessageProcessors());
        cpy.setEnableNotifications(this.isEnableNotifications());
        cpy.setLogException(this.logException);
        cpy.setNotificationFirer(this.notificationFirer);
        cpy.setAnnotations(this.getAnnotations());
        return cpy;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return new ArrayList<Processor>(super.getOwnedMessageProcessors());
    }

    private boolean isRedeliveryExhausted(Exception exception) {
        return exception instanceof MessageRedeliveredException;
    }

    @Override
    protected Function<CoreEvent, Publisher<CoreEvent>> route(Exception exception) {
        if (!this.isRedeliveryExhausted(exception)) {
            return super.route(exception);
        }
        this.logger.info("Message redelivery exhausted. No redelivery exhausted actions configured. Message consumed.");
        return event -> Mono.just((Object)event);
    }
}

