/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.internal.property.TransactionalActionModelProperty;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class DefaultExecutionContext<M extends ComponentModel>
implements ExecutionContextAdapter<M> {
    private static final ExtensionTransactionFactory TRANSACTION_FACTORY = new ExtensionTransactionFactory();
    private static final Supplier<Optional<TransactionConfig>> EMPTY_TX_CONFIG = () -> Optional.empty();
    private final ExtensionModel extensionModel;
    private final Optional<ConfigurationInstance> configuration;
    private final Map<String, Object> parameters;
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final M componentModel;
    private final MuleContext muleContext;
    private CoreEvent event;
    private SecurityContext securityContext;
    private final CursorProviderFactory cursorProviderFactory;
    private final StreamingManager streamingManager;
    private final Supplier<Optional<TransactionConfig>> transactionConfig;
    private final Component component;
    private final RetryPolicyTemplate retryPolicyTemplate;
    private Scheduler currentScheduler;

    public DefaultExecutionContext(ExtensionModel extensionModel, Optional<ConfigurationInstance> configuration, Map<String, Object> parameters, M componentModel, CoreEvent event, CursorProviderFactory cursorProviderFactory, StreamingManager streamingManager, Component component, RetryPolicyTemplate retryPolicyTemplate, Scheduler currentScheduler, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.configuration = configuration;
        this.event = event;
        this.securityContext = event.getSecurityContext();
        this.componentModel = componentModel;
        this.parameters = parameters;
        this.cursorProviderFactory = cursorProviderFactory;
        this.streamingManager = streamingManager;
        this.muleContext = muleContext;
        this.component = component;
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.currentScheduler = currentScheduler;
        boolean isTransactional = this.isTransactional(componentModel);
        this.transactionConfig = isTransactional ? new LazyValue<Supplier<Optional>>(() -> Optional.of(this.buildTransactionConfig())) : EMPTY_TX_CONFIG;
    }

    @Override
    public Optional<ConfigurationInstance> getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean hasParameter(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    @Override
    public <T> T getParameter(String parameterName) {
        if (this.hasParameter(parameterName)) {
            return (T)this.parameters.get(parameterName);
        }
        throw new NoSuchElementException(parameterName);
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public <T> T getVariable(String key) {
        return (T)this.variables.get(key);
    }

    @Override
    public Object setVariable(String key, Object value) {
        Preconditions.checkArgument(key != null, "null keys are not allowed");
        Preconditions.checkArgument(value != null, "null values are not allowed");
        return this.variables.put(key, value);
    }

    @Override
    public <T> T removeVariable(String key) {
        Preconditions.checkArgument(key != null, "null keys are not allowed");
        return (T)this.variables.remove(key);
    }

    @Override
    public CoreEvent getEvent() {
        return this.event;
    }

    @Override
    public void changeEvent(CoreEvent updated) {
        Objects.requireNonNull(this.event);
        this.event = updated;
        this.securityContext = this.event.getSecurityContext();
    }

    @Override
    public void setSecurityContext(SecurityContext securityContext) {
        Objects.requireNonNull(securityContext);
        this.securityContext = securityContext;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public void setCurrentScheduler(Scheduler currentScheduler) {
        this.currentScheduler = currentScheduler;
    }

    @Override
    public Scheduler getCurrentScheduler() {
        return this.currentScheduler;
    }

    @Override
    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    @Override
    public M getComponentModel() {
        return this.componentModel;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public CursorProviderFactory getCursorProviderFactory() {
        return this.cursorProviderFactory;
    }

    @Override
    public Optional<TransactionConfig> getTransactionConfig() {
        return this.transactionConfig.get();
    }

    @Override
    public StreamingManager getStreamingManager() {
        return this.streamingManager;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public ComponentLocation getComponentLocation() {
        return this.component.getLocation();
    }

    @Override
    public Optional<RetryPolicyTemplate> getRetryPolicyTemplate() {
        return Optional.ofNullable(this.retryPolicyTemplate);
    }

    private TransactionConfig buildTransactionConfig() {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setAction(MuleExtensionUtils.toActionCode(this.getTransactionalAction()));
        transactionConfig.setMuleContext(this.muleContext);
        transactionConfig.setFactory(TRANSACTION_FACTORY);
        return transactionConfig;
    }

    private OperationTransactionalAction getTransactionalAction() {
        try {
            Optional<ParameterModel> transactionalParameter = this.getTransactionalActionParameter();
            if (transactionalParameter.isPresent()) {
                return (OperationTransactionalAction)((Object)this.getParameter(transactionalParameter.get().getName()));
            }
            throw new NoSuchElementException();
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(String.format("Operation '%s' from extension '%s' is transactional but no transactional action defined", this.componentModel.getName(), this.extensionModel.getName()));
        }
    }

    private Optional<ParameterModel> getTransactionalActionParameter() {
        return this.componentModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(TransactionalActionModelProperty.class).isPresent()).findAny();
    }

    private boolean isTransactional(M componentModel) {
        return componentModel instanceof ConnectableComponentModel && ((ConnectableComponentModel)componentModel).isTransactional();
    }
}

