/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.util.concurrent.FunctionalReadWriteLock;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.DefaultErrorTypeRepository;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.util.rx.FluxSinkSupplier;
import org.mule.runtime.core.internal.util.rx.RoundRobinFluxSinkSupplier;
import org.mule.runtime.core.internal.util.rx.TransactionAwareFluxSinkSupplier;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Publisher;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class CommonSourcePolicy {
    public static final String POLICY_SOURCE_PARAMETERS_PROCESSOR = "policy.source.parametersProcessor";
    public static final String POLICY_SOURCE_CALLER_SINK = "policy.source.callerSink";
    private final FluxSinkSupplier<CoreEvent> policySink;
    private final AtomicBoolean disposed;
    private final FunctionalReadWriteLock readWriteLock;
    private final Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer;
    private final DefaultErrorTypeRepository errorTypeRepository;

    CommonSourcePolicy(Supplier<FluxSink<CoreEvent>> sinkFactory) {
        this(sinkFactory, Optional.empty());
    }

    CommonSourcePolicy(Supplier<FluxSink<CoreEvent>> sinkFactory, Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer) {
        this.policySink = new TransactionAwareFluxSinkSupplier<CoreEvent>(sinkFactory, new RoundRobinFluxSinkSupplier(Runtime.getRuntime().availableProcessors(), sinkFactory));
        this.sourcePolicyParametersTransformer = sourcePolicyParametersTransformer;
        this.readWriteLock = FunctionalReadWriteLock.readWriteLock();
        this.disposed = new AtomicBoolean(false);
        this.errorTypeRepository = new DefaultErrorTypeRepository();
    }

    public Publisher<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>> process(CoreEvent sourceEvent, MessageSourceResponseParametersProcessor respParamProcessor) {
        return (Publisher)this.readWriteLock.withReadLock(lockReleaser -> {
            if (!this.disposed.get()) {
                return Mono.create(callerSink -> ((FluxSink)this.policySink.get()).next((Object)EventQuickCopy.quickCopy(sourceEvent, (Map<String, Object>)ImmutableMap.of((Object)POLICY_SOURCE_PARAMETERS_PROCESSOR, (Object)respParamProcessor, (Object)POLICY_SOURCE_CALLER_SINK, (Object)callerSink))));
            }
            return Mono.just((Object)sourceEvent).map(event -> {
                MessagingException me = new MessagingException(I18nMessageFactory.createStaticMessage("Source policy already disposed"), sourceEvent);
                me.setProcessedEvent(CoreEvent.builder(sourceEvent).error(ErrorBuilder.builder(me).errorType(this.errorTypeRepository.getAnyErrorType()).build()).build());
                Supplier<Map<String, Object>> errorParameters = this.sourcePolicyParametersTransformer.isPresent() ? () -> this.sourcePolicyParametersTransformer.get().fromMessageToErrorResponseParameters(sourceEvent.getMessage()) : () -> respParamProcessor.getFailedExecutionResponseParametersFunction().apply(sourceEvent);
                SourcePolicyFailureResult result = new SourcePolicyFailureResult(me, errorParameters);
                return Either.left(result);
            });
        });
    }

    public MessageSourceResponseParametersProcessor getResponseParamsProcessor(CoreEvent event) {
        return (MessageSourceResponseParametersProcessor)((InternalEvent)event).getInternalParameter(POLICY_SOURCE_PARAMETERS_PROCESSOR);
    }

    public void finishFlowProcessing(CoreEvent event, Either<SourcePolicyFailureResult, SourcePolicySuccessResult> result) {
        if (!((BaseEventContext)event.getContext()).isComplete()) {
            ((BaseEventContext)event.getContext()).success(event);
        }
        ((MonoSink)((InternalEvent)event).getInternalParameter(POLICY_SOURCE_CALLER_SINK)).success(result);
    }

    public void finishFlowProcessing(CoreEvent event, Either<SourcePolicyFailureResult, SourcePolicySuccessResult> result, Throwable error) {
        if (!((BaseEventContext)event.getContext()).isComplete()) {
            ((BaseEventContext)event.getContext()).error(error);
        }
        ((MonoSink)((InternalEvent)event).getInternalParameter(POLICY_SOURCE_CALLER_SINK)).success(result);
    }

    public void dispose() {
        this.readWriteLock.withWriteLock(() -> {
            this.policySink.dispose();
            this.disposed.set(true);
        });
    }
}

