/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.OnExecuteNextErrorConsumer;
import org.mule.runtime.core.internal.policy.PolicyEventMapper;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PolicyNextActionMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyNextActionMessageProcessor.class);
    public static final String POLICY_NEXT_OPERATION = "policy.nextOperation";
    public static final String POLICY_NEXT_EVENT_CTX_IDS = "policy.next.eventCtxIds";
    public static final String POLICY_IS_PROPAGATE_MESSAGE_TRANSFORMATIONS = "policy.isPropagateMessageTransformations";
    @Inject
    private MuleContext muleContext;
    private PolicyNotificationHelper notificationHelper;
    private PolicyEventMapper policyEventMapper;

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.policyEventMapper = new PolicyEventMapper(this.getPolicyId());
        this.notificationHelper = new PolicyNotificationHelper(this.muleContext.getNotificationManager(), this.getPolicyId(), this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).doOnNext(coreEvent -> this.logExecuteNextEvent("Before execute-next", coreEvent.getContext(), coreEvent.getMessage(), this.getPolicyId())).doOnNext(event -> {
            this.popBeforeNextFlowFlowStackElement().accept((CoreEvent)event);
            this.notificationHelper.notification(2102).accept((CoreEvent)event);
        }).compose(eventPub -> Mono.subscriberContext().flatMapMany(ctx -> eventPub.flatMap(event -> ctx.hasKey((Object)POLICY_IS_PROPAGATE_MESSAGE_TRANSFORMATIONS) ? Mono.just((Object)this.policyEventMapper.onSourcePolicyNext((CoreEvent)event, (Boolean)ctx.get((Object)POLICY_IS_PROPAGATE_MESSAGE_TRANSFORMATIONS))) : Mono.just((Object)this.policyEventMapper.onOperationPolicyNext((CoreEvent)event))).transform((Function)ctx.get((Object)POLICY_NEXT_OPERATION)).cast(CoreEvent.class))).doOnNext(coreEvent -> {
            this.notificationHelper.fireNotification((CoreEvent)coreEvent, null, 2103);
            this.pushAfterNextFlowStackElement().accept((CoreEvent)coreEvent);
            this.logExecuteNextEvent("After execute-next", coreEvent.getContext(), coreEvent.getMessage(), this.getPolicyId());
        }).map(result -> this.policyEventMapper.fromPolicyNext((CoreEvent)result)).onErrorContinue(MessagingException.class, (error, v) -> new OnExecuteNextErrorConsumer(event -> this.policyEventMapper.fromPolicyNext((CoreEvent)event), this.notificationHelper, this.getLocation()).accept((Throwable)error));
    }

    private Consumer<CoreEvent> pushAfterNextFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.toPolicyLocation(this.getLocation()), null));
    }

    private String toPolicyLocation(ComponentLocation componentLocation) {
        return componentLocation.getParts().get(0).getPartPath() + "/" + componentLocation.getParts().get(1).getPartPath() + "[after next]";
    }

    private Consumer<CoreEvent> popBeforeNextFlowFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
    }

    private String getPolicyId() {
        return this.muleContext.getConfiguration().getId();
    }

    private void logExecuteNextEvent(String startingMessage, EventContext eventContext, Message message, String policyName) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("\nEvent Id: " + eventContext.getCorrelationId() + "\n" + startingMessage + ".\nPolicy: " + policyName + "\n" + message.getAttributes().getValue().toString());
        }
    }
}

