/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.transaction.TransactionAdapter;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class TryScope
extends AbstractMessageProcessorOwner
implements Scope {
    private static final Logger LOGGER = LoggerFactory.getLogger(TryScope.class);
    protected MessageProcessorChain nestedChain;
    protected MuleTransactionConfig transactionConfig;
    private FlowExceptionHandler messagingExceptionHandler;
    private List<Processor> processors;

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        if (this.nestedChain == null) {
            return event;
        }
        boolean txPrevoiuslyActive = TransactionCoordination.isTransactionActive();
        Transaction previousTx = TransactionCoordination.getInstance().getTransaction();
        TransactionalExecutionTemplate<CoreEvent> executionTemplate = TransactionalExecutionTemplate.createScopeTransactionalExecutionTemplate(this.muleContext, this.transactionConfig);
        ExecutionCallback<CoreEvent> processingCallback = () -> {
            Transaction currentTx = TransactionCoordination.getInstance().getTransaction();
            if (!txPrevoiuslyActive && TransactionCoordination.isTransactionActive() || txPrevoiuslyActive && previousTx != currentTx) {
                TransactionAdapter transaction = (TransactionAdapter)currentTx;
                transaction.setComponentLocation(this.getLocation());
                return MessageProcessors.processWithChildContextBlocking(event, this.nestedChain, Optional.ofNullable(this.getLocation()), this.messagingExceptionHandler);
            }
            return MessageProcessors.processWithChildContextBlocking(event, this.nestedChain, Optional.ofNullable(this.getLocation()), this.messagingExceptionHandler);
        };
        try {
            return executionTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.nestedChain, this.transactionConfig), (Throwable)e);
        }
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        if (this.nestedChain == null) {
            return publisher;
        }
        if (TransactionCoordination.isTransactionActive() || this.transactionConfig.getAction() != 6) {
            return Scope.super.apply(publisher);
        }
        return Flux.from(publisher).transform(event -> MessageProcessors.applyWithChildContext((Publisher<CoreEvent>)event, this.nestedChain, Optional.ofNullable(this.getLocation()), this.messagingExceptionHandler));
    }

    public void setExceptionListener(FlowExceptionHandler exceptionListener) {
        this.messagingExceptionHandler = exceptionListener;
    }

    public void setTransactionConfig(MuleTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public MuleTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors(MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation()), this.processors);
        if (this.messagingExceptionHandler == null) {
            this.messagingExceptionHandler = this.muleContext.getDefaultErrorHandler(Optional.of(this.getRootContainerLocation().toString()));
            if (this.messagingExceptionHandler instanceof ErrorHandler) {
                ErrorHandler errorHandler = (ErrorHandler)this.messagingExceptionHandler;
                Location location = Location.builderFromStringRepresentation(this.getLocation().getLocation()).build();
                errorHandler.setExceptionListenersLocation(location);
            }
        }
        LifecycleUtils.initialiseIfNeeded(this.messagingExceptionHandler, true, this.muleContext);
        super.initialise();
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.messagingExceptionHandler, LOGGER);
        super.dispose();
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.messagingExceptionHandler);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.messagingExceptionHandler);
        super.stop();
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }

    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        byte txAction = this.transactionConfig.getAction();
        if (txAction == 1 || txAction == 2) {
            return ReactiveProcessor.ProcessingType.BLOCKING;
        }
        return ReactiveProcessor.ProcessingType.CPU_LITE;
    }
}

