/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.internal.streaming.CursorProviderJanitor;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;

public abstract class ManagedCursorProvider<T extends Cursor>
implements CursorProvider<T> {
    private final CursorProvider<T> delegate;
    private final Set<Cursor> cursors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MutableStreamingStatistics statistics;
    private final CursorProviderJanitor janitor;

    protected ManagedCursorProvider(CursorProvider<T> delegate, MutableStreamingStatistics statistics) {
        this.delegate = delegate;
        this.janitor = new CursorProviderJanitor(delegate, this.cursors, statistics);
        this.statistics = statistics;
        statistics.incrementOpenProviders();
    }

    @Override
    public final T openCursor() {
        T cursor = this.delegate.openCursor();
        T managedCursor = this.managedCursor(cursor);
        this.cursors.add((Cursor)managedCursor);
        this.statistics.incrementOpenCursors();
        return managedCursor;
    }

    public CursorProvider<T> getDelegate() {
        return this.delegate;
    }

    protected abstract T managedCursor(T var1);

    @Override
    public final void releaseResources() {
        this.janitor.releaseResources();
    }

    public CursorProviderJanitor getJanitor() {
        return this.janitor;
    }

    @Override
    public void close() {
        this.janitor.close();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }
}

