/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal;

import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.internal.config.RuntimeComponentBuildingDefinitionsUtil;
import org.mule.runtime.core.internal.lock.ServerLockFactory;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginClassLoaderFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.policy.PolicyTemplateClassLoaderFactory;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.TrackingArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.TrackingDeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ToolingApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.DefaultClassLoaderManager;
import org.mule.runtime.module.deployment.impl.internal.artifact.ServiceRegistryDescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.BundlePluginDependenciesResolver;
import org.mule.runtime.module.deployment.impl.internal.plugin.MuleExtensionModelLoaderManager;
import org.mule.runtime.module.deployment.impl.internal.policy.ApplicationPolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderManager;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.license.api.LicenseValidatorProvider;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.mule.runtime.module.service.internal.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.internal.discoverer.DefaultServiceDiscoverer;
import org.mule.runtime.module.service.internal.discoverer.FileSystemServiceProviderDiscoverer;
import org.mule.runtime.module.service.internal.discoverer.ReflectionServiceResolver;
import org.mule.runtime.module.service.internal.manager.ServiceRegistry;

public class MuleArtifactResourcesRegistry {
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;
    private final DefaultDomainManager domainManager;
    private final DefaultDomainFactory domainFactory;
    private final DefaultApplicationFactory applicationFactory;
    private final DeployableArtifactClassLoaderFactory<DomainDescriptor> domainClassLoaderFactory;
    private final ArtifactClassLoader containerClassLoader;
    private final ServiceManager serviceManager;
    private final ExtensionModelLoaderManager extensionModelLoaderManager;
    private final ArtifactClassLoaderFactory<ArtifactPluginDescriptor> artifactPluginClassLoaderFactory;
    private final DefaultClassLoaderManager artifactClassLoaderManager;
    private final ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory;
    private final DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory;
    private final DomainDescriptorFactory domainDescriptorFactory;
    private final ApplicationDescriptorFactory applicationDescriptorFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final ServiceRegistryDescriptorLoaderRepository descriptorLoaderRepository;
    private final RegionPluginClassLoadersFactory pluginClassLoadersFactory;
    private final ToolingApplicationDescriptorFactory toolingApplicationDescriptorFactory;
    private final ServerLockFactory runtimeLockFactory = new ServerLockFactory();

    private MuleArtifactResourcesRegistry(ModuleRepository moduleRepository) {
        this.containerClassLoader = new ContainerClassLoaderFactory(moduleRepository).createContainerClassLoader(this.getClass().getClassLoader());
        this.artifactClassLoaderManager = new DefaultClassLoaderManager();
        LicenseValidator licenseValidator = LicenseValidatorProvider.discoverLicenseValidator(Thread.currentThread().getContextClassLoader());
        this.domainManager = new DefaultDomainManager();
        this.domainClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory(new DomainClassLoaderFactory(this.containerClassLoader.getClassLoader()));
        this.artifactPluginClassLoaderFactory = this.trackArtifactClassLoaderFactory(new ArtifactPluginClassLoaderFactory());
        ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory = new ArtifactPluginDescriptorFactory();
        this.artifactPluginDescriptorLoader = new ArtifactPluginDescriptorLoader(artifactPluginDescriptorFactory);
        this.descriptorLoaderRepository = new ServiceRegistryDescriptorLoaderRepository(new SpiServiceRegistry());
        ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder = ArtifactDescriptorValidatorBuilder.builder();
        this.domainDescriptorFactory = new DomainDescriptorFactory(this.artifactPluginDescriptorLoader, this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        this.applicationDescriptorFactory = new ApplicationDescriptorFactory(this.artifactPluginDescriptorLoader, this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        DeployableArtifactClassLoaderFactory<ApplicationDescriptor> applicationClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory(new MuleApplicationClassLoaderFactory(new DefaultNativeLibraryFinderFactory()));
        this.pluginDependenciesResolver = new BundlePluginDependenciesResolver(artifactPluginDescriptorFactory);
        this.pluginClassLoadersFactory = new DefaultRegionPluginClassLoadersFactory(this.artifactPluginClassLoaderFactory, moduleRepository);
        this.applicationClassLoaderBuilderFactory = new ApplicationClassLoaderBuilderFactory(applicationClassLoaderFactory, this.artifactPluginClassLoaderFactory, this.pluginClassLoadersFactory);
        this.domainClassLoaderBuilderFactory = new DomainClassLoaderBuilderFactory(this.containerClassLoader, this.domainClassLoaderFactory, this.pluginClassLoadersFactory);
        ServiceClassLoaderFactory serviceClassLoaderFactory = new ServiceClassLoaderFactory();
        this.serviceManager = ServiceManager.create(new DefaultServiceDiscoverer(new FileSystemServiceProviderDiscoverer(this.containerClassLoader, this.trackArtifactClassLoaderFactory(serviceClassLoaderFactory), this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder), new ReflectionServiceResolver(new ServiceRegistry())));
        this.extensionModelLoaderManager = new MuleExtensionModelLoaderManager(this.containerClassLoader);
        ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider = RuntimeComponentBuildingDefinitionsUtil.getRuntimeComponentBuildingDefinitionProvider();
        this.domainFactory = new DefaultDomainFactory(this.domainDescriptorFactory, this.domainManager, this.artifactClassLoaderManager, this.serviceManager, this.pluginDependenciesResolver, this.domainClassLoaderBuilderFactory, this.extensionModelLoaderManager, licenseValidator, runtimeComponentBuildingDefinitionProvider, this.runtimeLockFactory);
        DeployableArtifactClassLoaderFactory<PolicyTemplateDescriptor> policyClassLoaderFactory = this.trackDeployableArtifactClassLoaderFactory(new PolicyTemplateClassLoaderFactory());
        ApplicationPolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory = new ApplicationPolicyTemplateClassLoaderBuilderFactory(policyClassLoaderFactory, this.pluginClassLoadersFactory);
        this.applicationFactory = new DefaultApplicationFactory(this.applicationClassLoaderBuilderFactory, this.applicationDescriptorFactory, this.domainManager, this.serviceManager, this.extensionModelLoaderManager, this.artifactClassLoaderManager, policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver, this.artifactPluginDescriptorLoader, licenseValidator, runtimeComponentBuildingDefinitionProvider, this.runtimeLockFactory);
        this.toolingApplicationDescriptorFactory = new ToolingApplicationDescriptorFactory(this.artifactPluginDescriptorLoader, this.descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
    }

    private <T extends ArtifactDescriptor> ArtifactClassLoaderFactory<T> trackArtifactClassLoaderFactory(ArtifactClassLoaderFactory<T> artifactClassLoaderFactory) {
        return new TrackingArtifactClassLoaderFactory<T>(this.artifactClassLoaderManager, artifactClassLoaderFactory);
    }

    private <T extends ArtifactDescriptor> DeployableArtifactClassLoaderFactory<T> trackDeployableArtifactClassLoaderFactory(DeployableArtifactClassLoaderFactory<T> deployableArtifactClassLoaderFactory) {
        return new TrackingDeployableArtifactClassLoaderFactory<T>(this.artifactClassLoaderManager, deployableArtifactClassLoaderFactory);
    }

    public ArtifactPluginDescriptorLoader getArtifactPluginDescriptorLoader() {
        return this.artifactPluginDescriptorLoader;
    }

    public DefaultDomainFactory getDomainFactory() {
        return this.domainFactory;
    }

    public DomainRepository getDomainRepository() {
        return this.domainManager;
    }

    public DomainDescriptorFactory getDomainDescriptorFactory() {
        return this.domainDescriptorFactory;
    }

    public DefaultApplicationFactory getApplicationFactory() {
        return this.applicationFactory;
    }

    public DeployableArtifactClassLoaderFactory<DomainDescriptor> getDomainClassLoaderFactory() {
        return this.domainClassLoaderFactory;
    }

    public ArtifactClassLoaderFactory<ArtifactPluginDescriptor> getArtifactPluginClassLoaderFactory() {
        return this.artifactPluginClassLoaderFactory;
    }

    public ArtifactClassLoader getContainerClassLoader() {
        return this.containerClassLoader;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public ExtensionModelLoaderManager getExtensionModelLoaderManager() {
        return this.extensionModelLoaderManager;
    }

    public DefaultClassLoaderManager getArtifactClassLoaderManager() {
        return this.artifactClassLoaderManager;
    }

    public ToolingApplicationDescriptorFactory getToolingApplicationDescriptorFactory() {
        return this.toolingApplicationDescriptorFactory;
    }

    public PluginDependenciesResolver getPluginDependenciesResolver() {
        return this.pluginDependenciesResolver;
    }

    public ServerLockFactory getRuntimeLockFactory() {
        return this.runtimeLockFactory;
    }

    public static class Builder {
        private ModuleRepository moduleRepository;

        public Builder moduleRepository(ModuleRepository moduleRepository) {
            Preconditions.checkArgument(moduleRepository != null, "moduleRepository cannot be null");
            this.moduleRepository = moduleRepository;
            return this;
        }

        public MuleArtifactResourcesRegistry build() {
            if (this.moduleRepository == null) {
                this.moduleRepository = new DefaultModuleRepository(new ContainerModuleDiscoverer(this.getClass().getClassLoader()));
            }
            return new MuleArtifactResourcesRegistry(this.moduleRepository);
        }
    }
}

