/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.api.runtime.connection.transport;

import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.soap.MessageDispatcherProvider;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.soap.api.message.dispatcher.DefaultHttpMessageDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpMessageDispatcherProvider
implements MessageDispatcherProvider<MessageDispatcher>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpMessageDispatcher.class);
    @Inject
    private HttpService httpService;
    private HttpClient httpClient;

    @Override
    public MessageDispatcher connect() throws ConnectionException {
        return new DefaultHttpMessageDispatcher(this.httpClient);
    }

    @Override
    public void disconnect(MessageDispatcher connection) {
        LifecycleUtils.disposeIfNeeded(connection, LOGGER);
    }

    @Override
    public ConnectionValidationResult validate(MessageDispatcher connection) {
        return ConnectionValidationResult.success();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initialise() throws InitialisationException {
        this.httpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setName("soap-extension").build());
    }

    @Override
    public void stop() throws MuleException {
        this.httpClient.stop();
    }

    @Override
    public void start() throws MuleException {
        this.httpClient.start();
    }
}

