/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.OAuthAuthorizationCodeDancerBuilder;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;
import org.mule.service.oauth.internal.builder.DefaultOAuthAuthorizationCodeDancerBuilder;
import org.mule.service.oauth.internal.builder.DefaultOAuthClientCredentialsDancerBuilder;

public final class DefaultOAuthService
implements OAuthService {
    private final HttpService httpService;
    private final SchedulerService schedulerService;
    private final LoadingCache<Pair<TlsContextFactory, ProxyConfig>, HttpClient> httpClientCache;

    public DefaultOAuthService(HttpService httpService, SchedulerService schedulerService) {
        this.httpService = httpService;
        this.schedulerService = schedulerService;
        this.httpClientCache = Caffeine.newBuilder().build(key -> {
            HttpClientConfiguration.Builder clientConfigBuilder = new HttpClientConfiguration.Builder().setName("oauthToken.requester");
            clientConfigBuilder.setTlsContextFactory((TlsContextFactory)key.getFirst());
            clientConfigBuilder.setProxyConfig((ProxyConfig)key.getSecond());
            final HttpClient innerClient = httpService.getClientFactory().create(clientConfigBuilder.build());
            return new HttpClient((Pair)key){
                private final AtomicInteger startedCounter = new AtomicInteger(0);
                final /* synthetic */ Pair val$key;
                {
                    this.val$key = pair;
                }

                @Override
                public void start() {
                    if (0 == this.startedCounter.getAndIncrement()) {
                        innerClient.start();
                    }
                }

                @Override
                public void stop() {
                    if (0 == this.startedCounter.decrementAndGet()) {
                        innerClient.stop();
                        DefaultOAuthService.this.httpClientCache.invalidate((Object)this.val$key);
                    }
                }

                @Override
                public HttpResponse send(HttpRequest request, HttpRequestOptions options) throws IOException, TimeoutException {
                    return innerClient.send(request, options);
                }

                @Override
                public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, HttpRequestOptions options) {
                    return innerClient.sendAsync(request, options);
                }
            };
        });
    }

    @Override
    public String getName() {
        return "OAuthService";
    }

    @Override
    public <T> OAuthClientCredentialsDancerBuilder clientCredentialsGrantTypeDancerBuilder(LockFactory lockProvider, Map<String, T> tokensStore, MuleExpressionLanguage expressionEvaluator) {
        return new DefaultOAuthClientCredentialsDancerBuilder(this.schedulerService, lockProvider, tokensStore, this.httpClientCache, expressionEvaluator);
    }

    @Override
    public <T> OAuthAuthorizationCodeDancerBuilder authorizationCodeGrantTypeDancerBuilder(LockFactory lockProvider, Map<String, T> tokensStore, MuleExpressionLanguage expressionEvaluator) {
        return new DefaultOAuthAuthorizationCodeDancerBuilder(this.schedulerService, lockProvider, tokensStore, this.httpService, this.httpClientCache, expressionEvaluator);
    }
}

