/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.context.thread.notification.ThreadNotificationService;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.thread.notification.ThreadNotificationLogger;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.InterceptorManager;
import org.mule.runtime.core.internal.processor.chain.InterceptedReactiveProcessor;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveAroundInterceptorAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.component.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

abstract class AbstractMessageProcessorChain
extends AbstractExecutableComponent
implements MessageProcessorChain {
    private static final String TCCL_REACTOR_CTX_KEY = "mule.context.tccl";
    private static final String TCCL_ORIGINAL_REACTOR_CTX_KEY = "mule.context.tccl_original";
    private static final String REACTOR_ON_OPERATOR_ERROR_LOCAL = "reactor.onOperatorError.local";
    private static final String UNEXPECTED_ERROR_HANDLER_STATE_MESSAGE = "Unexpected state. Error handler should be invoked with either an Event instance or a MessagingException";
    private static Class<ClassLoader> appClClass;
    private static final Logger LOGGER;
    private static final Consumer<Context> TCCL_REACTOR_CTX_CONSUMER;
    private static final Consumer<Context> TCCL_ORIGINAL_REACTOR_CTX_CONSUMER;
    private final String name;
    private final List<Processor> processors;
    private final ProcessingStrategy processingStrategy;
    private final List<ReactiveInterceptorAdapter> additionalInterceptors = new LinkedList<ReactiveInterceptorAdapter>();
    @Inject
    private InterceptorManager processorInterceptorManager;
    @Inject
    private StreamingManager streamingManager;
    @Inject
    private ThreadNotificationService threadNotificationService;
    private ThreadNotificationLogger threadNotificationLogger;

    AbstractMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors) {
        this.name = name;
        this.processingStrategy = processingStrategyOptional.orElse(null);
        this.processors = processors;
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptors = this.resolveInterceptors();
        Flux stream = Flux.from(publisher);
        for (Processor processor : this.getProcessorsToExecute()) {
            stream = stream.transform((Function)this.applyInterceptors(interceptors, processor)).subscriberContext(context -> context.put((Object)REACTOR_ON_OPERATOR_ERROR_LOCAL, this.getLocalOperatorErrorHook(processor))).onErrorContinue(exception -> !(exception instanceof LifecycleException), this.getContinueStrategyErrorHandler(processor));
        }
        return stream.subscriberContext(ctx -> {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl == null || tccl.getParent() == null || appClClass == null || !appClClass.isAssignableFrom(tccl.getClass())) {
                return ctx;
            }
            return ctx.put((Object)TCCL_ORIGINAL_REACTOR_CTX_KEY, (Object)tccl).put((Object)TCCL_REACTOR_CTX_KEY, (Object)tccl.getParent());
        });
    }

    private BiFunction<Throwable, Object, Throwable> getLocalOperatorErrorHook(Processor processor) {
        return (throwable, event) -> {
            throwable = Exceptions.unwrap(throwable);
            if (event instanceof CoreEvent) {
                if (throwable instanceof MessagingException) {
                    return this.resolveMessagingException(processor).apply((MessagingException)throwable);
                }
                return this.resolveException(processor, (CoreEvent)event, (Throwable)throwable);
            }
            return throwable;
        };
    }

    private BiConsumer<Throwable, Object> getContinueStrategyErrorHandler(Processor processor) {
        return (throwable, object) -> {
            throwable = Exceptions.unwrap(throwable);
            if (object == null && !(throwable instanceof MessagingException)) {
                LOGGER.error(UNEXPECTED_ERROR_HANDLER_STATE_MESSAGE, throwable);
                throw new IllegalStateException(UNEXPECTED_ERROR_HANDLER_STATE_MESSAGE);
            }
            if (object != null && !(object instanceof CoreEvent) && throwable instanceof MessagingException) {
                this.notifyError(processor, (BaseEventContext)((MessagingException)throwable).getEvent().getContext(), this.resolveMessagingException(processor).apply((MessagingException)throwable));
            } else {
                CoreEvent event = (CoreEvent)object;
                if (throwable instanceof MessagingException) {
                    this.notifyError(processor, (BaseEventContext)(event != null ? event.getContext() : ((MessagingException)throwable).getEvent().getContext()), this.resolveMessagingException(processor).apply((MessagingException)throwable));
                } else {
                    this.notifyError(processor, (BaseEventContext)event.getContext(), this.resolveException(processor, event, (Throwable)throwable));
                }
            }
        };
    }

    private void notifyError(Processor processor, BaseEventContext context, MessagingException resolvedException) {
        this.errorNotification(processor).andThen(context::error).accept(resolvedException);
    }

    private ReactiveProcessor applyInterceptors(List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptorsToBeExecuted, Processor processor) {
        ReactiveProcessor interceptorWrapperProcessorFunction = processor;
        for (BiFunction<Processor, ReactiveProcessor, ReactiveProcessor> interceptor : interceptorsToBeExecuted) {
            interceptorWrapperProcessorFunction = interceptor.apply(processor, interceptorWrapperProcessorFunction);
        }
        return interceptorWrapperProcessorFunction;
    }

    private List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> resolveInterceptors() {
        ArrayList<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptors = new ArrayList<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>>();
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).doOnNext(event -> {
            DefaultMuleContext.currentMuleContext.set(this.muleContext);
            PrivilegedEvent.setCurrentEvent((PrivilegedEvent)event);
        }).transform(this.doOnNextOrErrorWithContext(TCCL_REACTOR_CTX_CONSUMER).andThen(next).andThen(this.doOnNextOrErrorWithContext(TCCL_ORIGINAL_REACTOR_CTX_CONSUMER))));
        if (this.processingStrategy != null) {
            if (this.muleContext.getConfiguration().isThreadLoggingEnabled()) {
                interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).subscriberContext(context -> context.put((Object)"mule.nb.ThreadNotificationLogger", (Object)this.threadNotificationLogger)).doOnNext(event -> this.threadNotificationLogger.setStartingThread(event.getContext().getId(), true)).transform((Function)this.processingStrategy.onProcessor(new InterceptedReactiveProcessor((Processor)processor, (ReactiveProcessor)next, this.threadNotificationLogger))).doOnNext(event -> this.threadNotificationLogger.setFinishThread(event.getContext().getId())));
            } else {
                interceptors.add((processor, next) -> this.processingStrategy.onProcessor(new InterceptedReactiveProcessor((Processor)processor, (ReactiveProcessor)next, null)));
            }
        }
        interceptors.addAll(this.additionalInterceptors);
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).doOnNext(this.preNotification((Processor)processor)).transform((Function)next).map(result -> {
            this.postNotification((Processor)processor).accept((CoreEvent)result);
            PrivilegedEvent.setCurrentEvent((PrivilegedEvent)result);
            return StreamingUtils.updateEventForStreaming(this.streamingManager).apply((CoreEvent)result);
        }));
        return interceptors;
    }

    private Function<? super Publisher<CoreEvent>, ? extends Publisher<CoreEvent>> doOnNextOrErrorWithContext(final Consumer<Context> contextConsumer) {
        return Operators.lift((scannable, subscriber) -> new CoreSubscriber<CoreEvent>(){
            private final Context context;
            {
                this.context = subscriber.currentContext();
            }

            public void onNext(CoreEvent event) {
                contextConsumer.accept(this.context);
                subscriber.onNext((Object)event);
            }

            public void onError(Throwable throwable) {
                contextConsumer.accept(this.context);
                subscriber.onError(throwable);
            }

            public void onComplete() {
                subscriber.onComplete();
            }

            public Context currentContext() {
                return this.context;
            }

            public void onSubscribe(Subscription s) {
                subscriber.onSubscribe(s);
            }
        });
    }

    private MessagingException resolveException(Processor processor, CoreEvent event, Throwable throwable) {
        if (processor instanceof Component) {
            MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver((Component)((Object)processor));
            return exceptionResolver.resolve(new MessagingException(event, throwable, (Component)((Object)processor)), this.muleContext);
        }
        return new MessagingException(event, throwable);
    }

    private Function<MessagingException, MessagingException> resolveMessagingException(Processor processor) {
        if (processor instanceof Component) {
            MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver((Component)((Object)processor));
            return exception -> exceptionResolver.resolve((MessagingException)exception, this.muleContext);
        }
        return exception -> exception;
    }

    private Consumer<CoreEvent> preNotification(Processor processor) {
        return event -> {
            if (((PrivilegedEvent)event).isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), (CoreEvent)event, processor, null, 1601);
            }
        };
    }

    private Consumer<CoreEvent> postNotification(Processor processor) {
        return event -> {
            if (((PrivilegedEvent)event).isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), (CoreEvent)event, processor, null, 1602);
            }
        };
    }

    private Consumer<Exception> errorNotification(Processor processor) {
        return exception -> {
            if (exception instanceof MessagingException && ((PrivilegedEvent)((MessagingException)exception).getEvent()).isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), ((MessagingException)exception).getEvent(), processor, (MessagingException)exception, 1602);
            }
        };
    }

    private void fireNotification(ServerNotificationManager serverNotificationManager, CoreEvent event, Processor processor, MessagingException exceptionThrown, int action) {
        if (serverNotificationManager != null && serverNotificationManager.isNotificationEnabled(MessageProcessorNotification.class) && ((Component)((Object)processor)).getLocation() != null) {
            serverNotificationManager.fireNotification(MessageProcessorNotification.createFrom(event, ((Component)((Object)processor)).getLocation(), (Component)((Object)processor), exceptionThrown, action));
        }
    }

    protected List<Processor> getProcessorsToExecute() {
        return this.processors;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.getClass().getSimpleName());
        if (!org.mule.runtime.core.api.util.StringUtils.isBlank(this.name)) {
            string.append(String.format(" '%s' ", this.name));
        }
        Iterator<Processor> mpIterator = this.processors.iterator();
        String nl = String.format("%n", new Object[0]);
        if (mpIterator.hasNext()) {
            string.append(String.format("%n[ ", new Object[0]));
            while (mpIterator.hasNext()) {
                Processor mp = mpIterator.next();
                String indented = StringUtils.replace((String)mp.toString(), (String)nl, (String)String.format("%n  ", new Object[0]));
                string.append(String.format("%n  %s", indented));
                if (!mpIterator.hasNext()) continue;
                string.append(", ");
            }
            string.append(String.format("%n]", new Object[0]));
        }
        return string.toString();
    }

    @Override
    public List<Processor> getMessageProcessors() {
        return this.processors;
    }

    protected List<Processor> getMessageProcessorsForLifecycle() {
        return this.processors;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        LifecycleUtils.setMuleContextIfNeeded(this.getMessageProcessorsForLifecycle(), muleContext);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.processorInterceptorManager.getInterceptorFactories().stream().forEach(interceptorFactory -> {
            ReactiveInterceptorAdapter reactiveInterceptorAdapter = new ReactiveInterceptorAdapter((ProcessorInterceptorFactory)interceptorFactory);
            try {
                this.muleContext.getInjector().inject(reactiveInterceptorAdapter);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException(e);
            }
            this.additionalInterceptors.add(0, reactiveInterceptorAdapter);
        });
        this.processorInterceptorManager.getInterceptorFactories().stream().forEach(interceptorFactory -> {
            ReactiveAroundInterceptorAdapter reactiveInterceptorAdapter = new ReactiveAroundInterceptorAdapter((ProcessorInterceptorFactory)interceptorFactory);
            try {
                this.muleContext.getInjector().inject(reactiveInterceptorAdapter);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException(e);
            }
            this.additionalInterceptors.add(0, reactiveInterceptorAdapter);
        });
        this.threadNotificationLogger = new ThreadNotificationLogger(this.threadNotificationService, this.muleContext.getConfiguration().isThreadLoggingEnabled());
        LifecycleUtils.initialiseIfNeeded(this.getMessageProcessorsForLifecycle(), this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        ArrayList<Processor> startedProcessors = new ArrayList<Processor>();
        try {
            for (Processor processor : this.getMessageProcessorsForLifecycle()) {
                if (!(processor instanceof Startable)) continue;
                ((Startable)((Object)processor)).start();
                startedProcessors.add(processor);
            }
        }
        catch (MuleException e) {
            LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
            throw e;
        }
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.getMessageProcessorsForLifecycle(), LOGGER);
    }

    static {
        LOGGER = LoggerFactory.getLogger(AbstractMessageProcessorChain.class);
        TCCL_REACTOR_CTX_CONSUMER = context -> context.getOrEmpty((Object)TCCL_REACTOR_CTX_KEY).ifPresent(cl -> Thread.currentThread().setContextClassLoader((ClassLoader)cl));
        TCCL_ORIGINAL_REACTOR_CTX_CONSUMER = context -> context.getOrEmpty((Object)TCCL_ORIGINAL_REACTOR_CTX_KEY).ifPresent(cl -> Thread.currentThread().setContextClassLoader((ClassLoader)cl));
        try {
            appClClass = AbstractMessageProcessorChain.class.getClassLoader().loadClass("org.mule.runtime.deployment.model.api.application.ApplicationClassLoader");
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("ApplicationClassLoader interface not available in current context", (Throwable)e);
        }
    }
}

