/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.routing;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.internal.config.ExceptionHelper;
import org.mule.runtime.core.privileged.routing.RoutingResult;

public final class CompositeRoutingException
extends MuleException
implements ComposedErrorException,
ErrorMessageAwareException {
    private static final String MESSAGE_TITLE = "Exception(s) were found for route(s): ";
    private static final long serialVersionUID = -4421728527040579607L;
    private final RoutingResult routingResult;

    public CompositeRoutingException(RoutingResult routingResult) {
        super(CompositeRoutingException.buildExceptionMessage(routingResult));
        this.routingResult = routingResult;
    }

    @Override
    public String getDetailedMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(MESSAGE_TITLE).append(System.lineSeparator());
        for (Map.Entry<String, Error> entry : this.routingResult.getFailures().entrySet()) {
            String routeSubtitle = String.format("Route %s: ", entry.getKey());
            MuleException muleException = ExceptionHelper.getRootMuleException(entry.getValue().getCause());
            if (muleException != null) {
                builder.append(routeSubtitle).append(muleException.getDetailedMessage());
                continue;
            }
            builder.append(routeSubtitle).append("Caught exception in Exception Strategy: " + entry.getValue().getCause().getMessage());
        }
        return builder.toString();
    }

    private static I18nMessage buildExceptionMessage(RoutingResult routingResult) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Error> routeResult : routingResult.getFailures().entrySet()) {
            Throwable routeException = routeResult.getValue().getCause();
            builder.append(System.lineSeparator() + "\t").append(routeResult.getKey()).append(": ").append(routeException.getClass().getName()).append(": ").append(routeException.getMessage());
        }
        builder.insert(0, MESSAGE_TITLE);
        return I18nMessageFactory.createStaticMessage(builder.toString());
    }

    @Override
    public List<Error> getErrors() {
        return this.routingResult.getFailures().values().stream().collect(Collectors.toList());
    }

    @Override
    public Message getErrorMessage() {
        return Message.of(this.routingResult);
    }
}

