/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.capability.xml.description.AbstractDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.ParameterDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.schema.MethodDocumentation;

final class SourcesDescriptionDocumenter
extends AbstractDescriptionDocumenter {
    private final ParameterDescriptionDocumenter parameterDeclarer;

    SourcesDescriptionDocumenter(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        this.parameterDeclarer = new ParameterDescriptionDocumenter(processingEnv);
    }

    void document(TypeElement element, WithSourcesDeclaration<?> ... containerDeclarations) {
        this.getSourceClasses(this.processingEnv, element).forEach(sourceElement -> this.findMatchingSource(containerDeclarations, (Element)sourceElement).ifPresent(source -> {
            source.setDescription(processor.getJavaDocSummary(this.processingEnv, (Element)sourceElement));
            this.parameterDeclarer.document((ParameterizedDeclaration<?>)source, (TypeElement)sourceElement);
            Map<String, Element> methods = this.getApiMethods(this.processingEnv, Collections.singletonList(sourceElement));
            source.getSuccessCallback().ifPresent(cb -> this.documentCallback(methods, (SourceCallbackDeclaration)cb));
            source.getErrorCallback().ifPresent(cb -> this.documentCallback(methods, (SourceCallbackDeclaration)cb));
        }));
    }

    private void documentCallback(Map<String, Element> methods, SourceCallbackDeclaration cb) {
        Element method = methods.get(cb.getName());
        if (method != null) {
            MethodDocumentation documentation = processor.getMethodDocumentation(this.processingEnv, method);
            this.parameterDeclarer.document(cb, method, documentation);
        }
    }

    private Optional<SourceDeclaration> findMatchingSource(WithSourcesDeclaration<?>[] containerDeclarations, Element element) {
        for (WithSourcesDeclaration<?> declaration : containerDeclarations) {
            Optional<SourceDeclaration> sourceDeclaration = declaration.getMessageSources().stream().filter(source -> {
                String elementName;
                String defaultNaming;
                String name = source.getName();
                if (name.equals(defaultNaming = NameUtils.hyphenize(elementName = element.getSimpleName().toString()))) return true;
                if (this.getAlias(element).map(name::equals).orElse(name.equals(elementName)) == false) return false;
                return true;
            }).findFirst();
            if (!sourceDeclaration.isPresent()) continue;
            return sourceDeclaration;
        }
        return Optional.empty();
    }

    private List<TypeElement> getSourceClasses(ProcessingEnvironment processingEnv, Element element) {
        return processor.getArrayClassAnnotationValue(element, Sources.class, "value", processingEnv);
    }
}

