/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithDeprecatedDeclaration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.deprecated.Deprecated;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.model.deprecated.ImmutableDeprecationModel;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;

public class DeprecationModelDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    private final Map<Class<? extends ModelProperty>, Function<ModelProperty, Optional<Deprecated>>> modelPropertiesClasses = this.createModelPropertiesClassesMap();

    private Map<Class<? extends ModelProperty>, Function<ModelProperty, Optional<Deprecated>>> createModelPropertiesClassesMap() {
        HashMap<Class<? extends ModelProperty>, Function<ModelProperty, Optional<Deprecated>>> modelPropertiesClassesMap = new HashMap<Class<? extends ModelProperty>, Function<ModelProperty, Optional<Deprecated>>>();
        modelPropertiesClassesMap.put(ImplementingTypeModelProperty.class, modelProperty -> this.getDeprecatedAnnotation((ImplementingTypeModelProperty)modelProperty));
        modelPropertiesClassesMap.put(ImplementingParameterModelProperty.class, modelProperty -> this.getDeprecatedAnnotation((ImplementingParameterModelProperty)modelProperty));
        modelPropertiesClassesMap.put(ImplementingMethodModelProperty.class, modelProperty -> this.getDeprecatedAnnotation((ImplementingMethodModelProperty)modelProperty));
        return modelPropertiesClassesMap;
    }

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        this.enrichDeclaration(extensionDeclaration, ImplementingTypeModelProperty.class);
        new IdempotentDeclarationWalker(){

            @Override
            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                DeprecationModelDeclarationEnricher.this.enrichDeclaration(declaration, ImplementingTypeModelProperty.class);
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                DeprecationModelDeclarationEnricher.this.enrichDeclaration(declaration, ImplementingTypeModelProperty.class);
            }

            @Override
            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                DeprecationModelDeclarationEnricher.this.enrichDeclaration(declaration, ImplementingParameterModelProperty.class);
            }

            @Override
            protected void onConstruct(ConstructDeclaration declaration) {
                DeprecationModelDeclarationEnricher.this.enrichDeclaration(declaration, ImplementingMethodModelProperty.class);
            }

            @Override
            protected void onConfiguration(ConfigurationDeclaration declaration) {
                DeprecationModelDeclarationEnricher.this.enrichDeclaration(declaration, ImplementingTypeModelProperty.class);
            }

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                DeprecationModelDeclarationEnricher.this.enrichDeclaration(declaration, ImplementingMethodModelProperty.class);
            }

            @Override
            protected void onFunction(FunctionDeclaration declaration) {
                DeprecationModelDeclarationEnricher.this.enrichDeclaration(declaration, ImplementingMethodModelProperty.class);
            }
        }.walk(extensionDeclaration);
    }

    private void enrichDeclaration(BaseDeclaration<?> declaration, Class<? extends ModelProperty> modelPropertyClass) {
        if (!(declaration instanceof WithDeprecatedDeclaration)) {
            return;
        }
        WithDeprecatedDeclaration withDeprecatedDeclaration = (WithDeprecatedDeclaration)((Object)declaration);
        this.getDeprecatedAnnotation(declaration, modelPropertyClass).ifPresent(deprecationAnnotation -> withDeprecatedDeclaration.withDeprecation(this.createDeprecationModel((Deprecated)deprecationAnnotation)));
    }

    private DeprecationModel createDeprecationModel(Deprecated deprecationAnnotation) {
        return new ImmutableDeprecationModel(deprecationAnnotation.message(), deprecationAnnotation.since(), StringUtils.isBlank(deprecationAnnotation.toRemoveIn()) ? null : deprecationAnnotation.toRemoveIn());
    }

    private Optional<Deprecated> getDeprecatedAnnotation(BaseDeclaration<?> declaration, Class<? extends ModelProperty> modelPropertyClass) {
        Optional<? extends ModelProperty> modelProperty = declaration.getModelProperty(modelPropertyClass);
        if (modelProperty.isPresent()) {
            return this.modelPropertiesClasses.get(modelPropertyClass).apply(modelProperty.get());
        }
        return Optional.empty();
    }

    private Optional<Deprecated> getDeprecatedAnnotation(ImplementingMethodModelProperty modelProperty) {
        return Optional.ofNullable(modelProperty.getMethod().getAnnotation(Deprecated.class));
    }

    private Optional<Deprecated> getDeprecatedAnnotation(ImplementingParameterModelProperty modelProperty) {
        return Optional.ofNullable(modelProperty.getParameter().getAnnotation(Deprecated.class));
    }

    private Optional<Deprecated> getDeprecatedAnnotation(ImplementingTypeModelProperty modelProperty) {
        return Optional.ofNullable(modelProperty.getType().getAnnotation(Deprecated.class));
    }
}

