/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.oauth.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public final class ResourceOwnerOAuthContextUtils {
    private static Class<? extends ResourceOwnerOAuthContext> ctxWithStateClass;
    private static Method ctxWithStateSetAccessTokenMethod;
    private static Method ctxWithStateSetRefreshTokenMethod;
    private static Method ctxWithStateSetExpiresInMethod;
    private static Method ctxWithStateSetStateMethod;
    private static Class<Enum> dancerStateEnumClass;
    private static Method ctxWithStateGetDancerStateMethod;
    private static Method ctxWithStateSetDancerStateMethod;
    private static Method createRefreshUserOAuthContextLock;
    private static Method getRefreshUserOAuthContextLock;
    private static Constructor<? extends ResourceOwnerOAuthContext> ctxWithStateCtor;
    private static Constructor<? extends ResourceOwnerOAuthContext> ctxWithStateCopyConstructor;
    private static final Map<String, CompletableFuture<Void>> activeRefreshFutures;

    private ResourceOwnerOAuthContextUtils() {
    }

    public static ResourceOwnerOAuthContext createResourceOwnerOAuthContext(Lock refreshUserOAuthContextLock, String resourceOwnerId) {
        try {
            if (ctxWithStateCtor != null) {
                return ctxWithStateCtor.newInstance(resourceOwnerId);
            }
            return new DefaultResourceOwnerOAuthContext(refreshUserOAuthContextLock, resourceOwnerId);
        }
        catch (InvocationTargetException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public static ResourceOwnerOAuthContext migrateContextIfNeeded(ResourceOwnerOAuthContext resourceOwnerOAuthContext, String name, LockFactory lockFactory) {
        if (ctxWithStateClass != null) {
            try {
                return ctxWithStateCopyConstructor.newInstance(resourceOwnerOAuthContext);
            }
            catch (InstantiationException | InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException(e);
            }
        }
        ((DefaultResourceOwnerOAuthContext)resourceOwnerOAuthContext).setRefreshUserOAuthContextLock(ResourceOwnerOAuthContextUtils.createLockForResourceOwner(resourceOwnerOAuthContext.getResourceOwnerId(), name, lockFactory));
        return resourceOwnerOAuthContext;
    }

    private static Lock createLockForResourceOwner(String resourceOwnerId, String configName, LockFactory lockFactory) {
        return lockFactory.createLock(configName + "-" + resourceOwnerId);
    }

    public static Lock getRefreshUserOAuthContextLock(ResourceOwnerOAuthContext resourceOwnerOAuthContext, String name, LockFactory lockFactory) {
        if (getRefreshUserOAuthContextLock != null) {
            try {
                return (Lock)getRefreshUserOAuthContextLock.invoke((Object)resourceOwnerOAuthContext, name, lockFactory);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
        }
        return ((DefaultResourceOwnerOAuthContext)resourceOwnerOAuthContext).getRefreshUserOAuthContextLock();
    }

    public static Lock createRefreshUserOAuthContextLock(String lockNamePrefix, LockFactory lockProvider, String resourceOwnerId) {
        if (createRefreshUserOAuthContextLock != null) {
            try {
                return (Lock)createRefreshUserOAuthContextLock.invoke(null, lockNamePrefix, lockProvider, resourceOwnerId);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
        }
        return lockProvider.createLock(lockNamePrefix + "-config-oauth-context");
    }

    public static void setAccessToken(ResourceOwnerOAuthContext resourceOwnerOAuthContext, String accessToken) {
        try {
            if (ctxWithStateSetAccessTokenMethod != null) {
                ctxWithStateSetAccessTokenMethod.invoke((Object)resourceOwnerOAuthContext, accessToken);
            } else {
                ((DefaultResourceOwnerOAuthContext)resourceOwnerOAuthContext).setAccessToken(accessToken);
            }
        }
        catch (InvocationTargetException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public static void setRefreshToken(ResourceOwnerOAuthContext resourceOwnerOAuthContext, String refreshToken) {
        try {
            if (ctxWithStateSetRefreshTokenMethod != null) {
                ctxWithStateSetRefreshTokenMethod.invoke((Object)resourceOwnerOAuthContext, refreshToken);
            } else {
                ((DefaultResourceOwnerOAuthContext)resourceOwnerOAuthContext).setRefreshToken(refreshToken);
            }
        }
        catch (InvocationTargetException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public static void setExpiresIn(ResourceOwnerOAuthContext resourceOwnerOAuthContext, String expiresIn) {
        try {
            if (ctxWithStateSetExpiresInMethod != null) {
                ctxWithStateSetExpiresInMethod.invoke((Object)resourceOwnerOAuthContext, expiresIn);
            } else {
                ((DefaultResourceOwnerOAuthContext)resourceOwnerOAuthContext).setExpiresIn(expiresIn);
            }
        }
        catch (InvocationTargetException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public static void setState(ResourceOwnerOAuthContext resourceOwnerOAuthContext, String state) {
        try {
            if (ctxWithStateSetStateMethod != null) {
                ctxWithStateSetStateMethod.invoke((Object)resourceOwnerOAuthContext, state);
            } else {
                ((DefaultResourceOwnerOAuthContext)resourceOwnerOAuthContext).setState(state);
            }
        }
        catch (InvocationTargetException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public static void setDancerStateRefreshingToken(ResourceOwnerOAuthContext resourceOwnerOAuthContext, CompletableFuture<Void> refreshFuture) {
        if (ctxWithStateSetDancerStateMethod != null) {
            try {
                ctxWithStateSetDancerStateMethod.invoke((Object)resourceOwnerOAuthContext, Enum.valueOf(dancerStateEnumClass, "REFRESHING_TOKEN"));
            }
            catch (InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException(e);
            }
        } else {
            activeRefreshFutures.put("" + resourceOwnerOAuthContext.getResourceOwnerId(), refreshFuture);
        }
    }

    public static boolean isDancerStateRefreshingToken(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        if (ctxWithStateGetDancerStateMethod != null) {
            try {
                return Enum.valueOf(dancerStateEnumClass, "REFRESHING_TOKEN").equals(ctxWithStateGetDancerStateMethod.invoke((Object)resourceOwnerOAuthContext, new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException(e);
            }
        }
        return activeRefreshFutures.containsKey("" + resourceOwnerOAuthContext.getResourceOwnerId());
    }

    public static void setDancerStateHasToken(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        if (ctxWithStateSetDancerStateMethod != null) {
            try {
                ctxWithStateSetDancerStateMethod.invoke((Object)resourceOwnerOAuthContext, Enum.valueOf(dancerStateEnumClass, "HAS_TOKEN"));
            }
            catch (InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException(e);
            }
        } else {
            activeRefreshFutures.remove("" + resourceOwnerOAuthContext.getResourceOwnerId());
        }
    }

    public static boolean isDancerStateHasToken(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        if (ctxWithStateGetDancerStateMethod != null) {
            try {
                return Enum.valueOf(dancerStateEnumClass, "HAS_TOKEN").equals(ctxWithStateGetDancerStateMethod.invoke((Object)resourceOwnerOAuthContext, new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException(e);
            }
        }
        return !activeRefreshFutures.containsKey("" + resourceOwnerOAuthContext.getResourceOwnerId()) && resourceOwnerOAuthContext.getAccessToken() != null;
    }

    public static void setDancerStateNoToken(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        if (ctxWithStateSetDancerStateMethod != null) {
            try {
                ctxWithStateSetDancerStateMethod.invoke((Object)resourceOwnerOAuthContext, Enum.valueOf(dancerStateEnumClass, "NO_TOKEN"));
            }
            catch (InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException(e);
            }
        } else {
            String nullSafeResourceOwner = "" + resourceOwnerOAuthContext.getResourceOwnerId();
            activeRefreshFutures.remove(nullSafeResourceOwner);
        }
    }

    public static boolean isDancerStateNoToken(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        if (ctxWithStateGetDancerStateMethod != null) {
            try {
                return Enum.valueOf(dancerStateEnumClass, "NO_TOKEN").equals(ctxWithStateGetDancerStateMethod.invoke((Object)resourceOwnerOAuthContext, new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException(e);
            }
        }
        return !activeRefreshFutures.containsKey("" + resourceOwnerOAuthContext.getResourceOwnerId()) && resourceOwnerOAuthContext.getAccessToken() == null;
    }

    static {
        createRefreshUserOAuthContextLock = null;
        getRefreshUserOAuthContextLock = null;
        try {
            ctxWithStateClass = Class.forName("org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState");
            ctxWithStateSetAccessTokenMethod = ctxWithStateClass.getDeclaredMethod("setAccessToken", String.class);
            ctxWithStateSetRefreshTokenMethod = ctxWithStateClass.getDeclaredMethod("setRefreshToken", String.class);
            ctxWithStateSetExpiresInMethod = ctxWithStateClass.getDeclaredMethod("setExpiresIn", String.class);
            ctxWithStateSetStateMethod = ctxWithStateClass.getDeclaredMethod("setState", String.class);
            dancerStateEnumClass = Class.forName("org.mule.runtime.oauth.api.state.DancerState");
            ctxWithStateGetDancerStateMethod = ctxWithStateClass.getDeclaredMethod("getDancerState", new Class[0]);
            ctxWithStateSetDancerStateMethod = ctxWithStateClass.getDeclaredMethod("setDancerState", dancerStateEnumClass);
            getRefreshUserOAuthContextLock = ctxWithStateClass.getDeclaredMethod("getRefreshOAuthContextLock", String.class, LockFactory.class);
            createRefreshUserOAuthContextLock = ctxWithStateClass.getDeclaredMethod("createRefreshOAuthContextLock", String.class, LockFactory.class, String.class);
            ctxWithStateCtor = ctxWithStateClass.getConstructor(String.class);
            ctxWithStateCopyConstructor = ctxWithStateClass.getConstructor(ResourceOwnerOAuthContext.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
        }
        catch (SecurityException e) {
            throw e;
        }
        activeRefreshFutures = new ConcurrentHashMap<String, CompletableFuture<Void>>();
    }
}

