/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.api.dsl.processor.AbstractAttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;

public final class ComponentBuildingDefinitionRegistry {
    private final Map<ComponentIdentifier, ComponentBuildingDefinition<?>> builderDefinitionsMap = new HashMap();
    private final Map<String, WrapperElementType> wrapperIdentifierAndTypeMap = new HashMap<String, WrapperElementType>();

    public void register(ComponentBuildingDefinition<?> builderDefinition) {
        this.builderDefinitionsMap.put(builderDefinition.getComponentIdentifier(), builderDefinition);
        this.wrapperIdentifierAndTypeMap.putAll(this.getWrapperIdentifierAndTypeMap(builderDefinition));
    }

    public Optional<ComponentBuildingDefinition<?>> getBuildingDefinition(ComponentIdentifier identifier) {
        return Optional.ofNullable(this.builderDefinitionsMap.get(identifier));
    }

    public Optional<WrapperElementType> getWrappedComponent(ComponentIdentifier wrapperIdentifier) {
        return Optional.ofNullable(this.wrapperIdentifierAndTypeMap.get(wrapperIdentifier.toString()));
    }

    private <T> Map<String, WrapperElementType> getWrapperIdentifierAndTypeMap(final ComponentBuildingDefinition<T> buildingDefinition) {
        final HashMap<String, WrapperElementType> wrapperIdentifierAndTypeMap = new HashMap<String, WrapperElementType>();
        AbstractAttributeDefinitionVisitor wrapperIdentifiersCollector = new AbstractAttributeDefinitionVisitor(){

            @Override
            public void onComplexChildCollection(Class<?> type, Optional<String> wrapperIdentifierOptional) {
                wrapperIdentifierOptional.ifPresent(wrapperIdentifier -> wrapperIdentifierAndTypeMap.put(this.abbreviateIdentifier(buildingDefinition, (String)wrapperIdentifier), WrapperElementType.COLLECTION));
            }

            @Override
            public void onComplexChild(Class<?> type, Optional<String> wrapperIdentifierOptional, Optional<String> childIdentifier) {
                wrapperIdentifierOptional.ifPresent(wrapperIdentifier -> wrapperIdentifierAndTypeMap.put(this.abbreviateIdentifier(buildingDefinition, (String)wrapperIdentifier), WrapperElementType.SINGLE));
            }

            @Override
            public void onComplexChildMap(Class<?> keyType, Class<?> valueType, String wrapperIdentifier) {
                wrapperIdentifierAndTypeMap.put(this.abbreviateIdentifier(buildingDefinition, wrapperIdentifier), WrapperElementType.MAP);
            }

            private <T> String abbreviateIdentifier(ComponentBuildingDefinition<T> buildingDefinition2, String wrapperIdentifier) {
                String namespace = buildingDefinition2.getComponentIdentifier().getNamespace();
                if ("mule".equals(namespace)) {
                    return wrapperIdentifier;
                }
                return namespace + ":" + wrapperIdentifier;
            }

            @Override
            public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
                for (KeyAttributeDefinitionPair attributeDefinition : definitions) {
                    attributeDefinition.getAttributeDefinition().accept(this);
                }
            }
        };
        Consumer<AttributeDefinition> collectWrappersConsumer = attributeDefinition -> attributeDefinition.accept(wrapperIdentifiersCollector);
        buildingDefinition.getSetterParameterDefinitions().stream().map(setterAttributeDefinition -> setterAttributeDefinition.getAttributeDefinition()).forEach(collectWrappersConsumer);
        buildingDefinition.getConstructorAttributeDefinition().stream().forEach(collectWrappersConsumer);
        return wrapperIdentifierAndTypeMap;
    }

    public static enum WrapperElementType {
        SINGLE,
        COLLECTION,
        MAP;

    }
}

