/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.model;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

public class DslElementModel<T> {
    private final T model;
    private final String value;
    private final DslElementSyntax dsl;
    private final boolean explicitInDsl;
    private final Set<DslElementModel> containedElements;
    private final ComponentConfiguration configuration;
    private final ComponentIdentifier identifier;

    private DslElementModel(T model, DslElementSyntax dsl, Set<DslElementModel> containedElements, ComponentConfiguration configuration, String value, boolean explicitInDsl) {
        this.dsl = dsl;
        this.model = model;
        this.containedElements = containedElements;
        this.configuration = configuration;
        this.value = value;
        this.identifier = this.createIdentifier();
        this.explicitInDsl = explicitInDsl;
    }

    public T getModel() {
        return this.model;
    }

    public DslElementSyntax getDsl() {
        return this.dsl;
    }

    public List<DslElementModel> getContainedElements() {
        return ImmutableList.copyOf(this.containedElements);
    }

    public Optional<ComponentIdentifier> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    public Optional<ComponentConfiguration> getConfiguration() {
        return Optional.ofNullable(this.configuration);
    }

    public Optional<ComponentAst> getComponentModel() {
        return this.configuration.getProperty(ComponentModel.COMPONENT_MODEL_KEY).map(cm -> (ComponentAst)cm);
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public boolean isExplicitInDsl() {
        return this.explicitInDsl;
    }

    public <E> Optional<DslElementModel<E>> findElement(ComponentIdentifier identifier) {
        if (this.identifier != null && this.identifier.equals(identifier)) {
            return Optional.of(this);
        }
        return this.find(e -> e.findElement(identifier));
    }

    public <E> Optional<DslElementModel<E>> findElement(String modelName) {
        if (this.dsl.getAttributeName().equals(modelName) || this.model instanceof NamedObject && ((NamedObject)this.model).getName().equals(modelName)) {
            return Optional.of(this);
        }
        return this.find(e -> e.findElement(modelName));
    }

    private ComponentIdentifier createIdentifier() {
        if (this.configuration != null) {
            return this.configuration.getIdentifier();
        }
        if (!this.dsl.supportsTopLevelDeclaration() && !this.dsl.supportsChildDeclaration()) {
            return null;
        }
        return ComponentIdentifier.builder().name(this.dsl.getElementName()).namespace(this.dsl.getPrefix()).build();
    }

    private <E> Optional<DslElementModel<E>> find(Function<DslElementModel, Optional<DslElementModel>> finder) {
        return this.containedElements.stream().map(finder).filter(Optional::isPresent).map(Optional::get).map(e -> e).findFirst();
    }

    public static <M> Builder<M> builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DslElementModel that = (DslElementModel)o;
        return this.explicitInDsl == that.explicitInDsl && Objects.equals(this.model, that.model) && Objects.equals(this.value, that.value) && Objects.equals(this.dsl, that.dsl) && Objects.equals(this.containedElements, that.containedElements) && Objects.equals(this.configuration, that.configuration) && Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.value, this.dsl, this.explicitInDsl, this.containedElements, this.configuration, this.identifier);
    }

    public static final class Builder<M> {
        private M model;
        private String value;
        private DslElementSyntax dsl;
        private ComponentConfiguration configuration;
        private final Set<DslElementModel> contained = new LinkedHashSet<DslElementModel>();
        private boolean explicitInDsl = true;

        private Builder() {
        }

        public Builder<M> withModel(M model) {
            this.model = model;
            return this;
        }

        public Builder<M> withDsl(DslElementSyntax dsl) {
            this.dsl = dsl;
            return this;
        }

        public Builder<M> containing(DslElementModel element) {
            this.contained.add(element);
            return this;
        }

        public Builder<M> withConfig(ComponentConfiguration element) {
            this.configuration = element;
            return this;
        }

        public Builder<M> withConfig(ComponentAst element) {
            this.configuration = ((ComponentModel)((Object)element)).getConfiguration();
            return this;
        }

        public Builder<M> withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder<M> isExplicitInDsl(boolean explicit) {
            this.explicitInDsl = explicit;
            return this;
        }

        public DslElementModel<M> build() {
            if (this.configuration != null) {
                Optional<String> configurationValue = this.configuration.getValue();
                if (configurationValue.isPresent() && !StringUtils.isBlank((CharSequence)configurationValue.get())) {
                    if (this.value == null) {
                        this.value = configurationValue.get();
                    } else {
                        Preconditions.checkState(this.value.equals(configurationValue.get()), "The same element cannot have two different values associated.");
                    }
                } else {
                    Preconditions.checkState(this.value == null, "The same element cannot have two different values associated.");
                }
            }
            return new DslElementModel(this.model, this.dsl, this.contained, this.configuration, this.value, this.explicitInDsl);
        }
    }
}

