/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.dsl.api.component.DslSimpleType;
import org.mule.runtime.dsl.api.component.TypeConverter;

class SimpleTypeBeanDefinitionCreator
extends BeanDefinitionCreator {
    SimpleTypeBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(createBeanDefinitionRequest.getComponentModel());
        createBeanDefinitionRequest.getComponentBuildingDefinition().getTypeDefinition().visit(objectTypeVisitor);
        Class<?> type = objectTypeVisitor.getType();
        if (DslSimpleType.isSimpleType(type)) {
            String value;
            SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
            componentModel.setType(type);
            Map<String, String> parameters = componentModel.getRawParameters();
            if (parameters.size() >= 2) {
                return false;
            }
            if (componentModel.getTextContent() != null && !componentModel.getRawParameters().isEmpty()) {
                return false;
            }
            String string = componentModel.getTextContent() != null ? componentModel.getTextContent() : (value = parameters.values().isEmpty() ? null : parameters.values().iterator().next());
            if (value == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Parameter at %s:%s must provide a non-empty value", componentModel.getConfigFileName().orElse("unknown"), componentModel.getLineNumber().orElse(-1)));
            }
            Optional<TypeConverter> typeConverterOptional = createBeanDefinitionRequest.getComponentBuildingDefinition().getTypeConverter();
            componentModel.setBeanDefinition(this.getConvertibleBeanDefinition(type, value, typeConverterOptional));
            return true;
        }
        return false;
    }
}

