/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleManifest {
    protected static final Logger logger = LoggerFactory.getLogger(MuleManifest.class);
    private static Manifest manifest;

    public static String getProductVersion() {
        String version = MuleManifest.getManifestProperty("Implementation-Version");
        return version == null ? "4.3.0" : version;
    }

    public static String getVendorName() {
        return MuleManifest.getManifestProperty("Specification-Vendor");
    }

    public static String getVendorUrl() {
        return MuleManifest.getManifestProperty("Vendor-Url");
    }

    public static String getProductUrl() {
        return MuleManifest.getManifestProperty("Product-Url");
    }

    public static String getProductName() {
        return MuleManifest.getManifestProperty("Implementation-Title");
    }

    public static String getProductMoreInfo() {
        return MuleManifest.getManifestProperty("More-Info");
    }

    public static String getProductSupport() {
        return MuleManifest.getManifestProperty("Support");
    }

    public static String getProductLicenseInfo() {
        return MuleManifest.getManifestProperty("License");
    }

    public static String getProductDescription() {
        return MuleManifest.getManifestProperty("Description");
    }

    public static String getBuildNumber() {
        return MuleManifest.getManifestProperty("Build-Revision");
    }

    public static String getBuildDate() {
        return MuleManifest.getManifestProperty("Build-Date");
    }

    public static String getSupportedJdks() {
        return MuleManifest.getManifestProperty("Supported-Jdks");
    }

    public static String getRecommndedJdks() {
        return MuleManifest.getManifestProperty("Recommended-Jdks");
    }

    public static synchronized Manifest getManifest() {
        if (manifest == null) {
            manifest = new Manifest();
            InputStream is = null;
            try {
                URL url = AccessController.doPrivileged(new UrlPrivilegedAction());
                if (url != null) {
                    is = url.openStream();
                }
                if (is != null) {
                    manifest.read(is);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to read manifest Info, Manifest information will not display correctly: " + e.getMessage());
            }
        }
        return manifest;
    }

    protected static String getManifestProperty(String name) {
        return MuleManifest.getManifest().getMainAttributes().getValue(new Attributes.Name(name));
    }

    private MuleManifest() {
    }

    static class UrlPrivilegedAction
    implements PrivilegedAction<URL> {
        UrlPrivilegedAction() {
        }

        @Override
        public URL run() {
            URL result = null;
            try {
                Enumeration<URL> e = MuleConfiguration.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                result = this.getManifestJarURL(e);
                if (result == null) {
                    result = this.getManifestTestJarURL();
                }
            }
            catch (IOException e1) {
                logger.warn("Failure reading manifest: " + e1.getMessage(), (Throwable)e1);
            }
            return result;
        }

        URL getManifestJarURL(Enumeration<URL> e) {
            TreeMap<String, URL> candidates = new TreeMap<String, URL>();
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if ((url.toExternalForm().indexOf("mule-core") <= -1 || url.toExternalForm().indexOf("tests.jar") >= 0) && !url.toExternalForm().matches(".*mule.*-.*-embedded.*\\.jar.*")) continue;
                candidates.put(url.toExternalForm(), url);
            }
            if (!candidates.isEmpty()) {
                for (String candidateKey : candidates.keySet()) {
                    if (!candidateKey.contains("mule-core-ee")) continue;
                    return (URL)candidates.get(candidateKey);
                }
                return (URL)candidates.get(candidates.lastKey());
            }
            return null;
        }

        URL getManifestTestJarURL() throws IOException {
            String testManifestPath = "core-tests/target/test-classes";
            Enumeration<URL> e = MuleConfiguration.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if ((url.toExternalForm().indexOf(testManifestPath) <= -1 || url.toExternalForm().indexOf("tests.jar") >= 0) && !url.toExternalForm().matches(".*mule.*-.*-embedded.*\\.jar.*")) continue;
                return url;
            }
            return null;
        }
    }
}

