/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;

public final class CompositeErrorTypeRepository
implements ErrorTypeRepository {
    private final ErrorTypeRepository childErrorTypeRepository;
    private final ErrorTypeRepository parentErrorTypeRepository;

    public CompositeErrorTypeRepository(ErrorTypeRepository childErrorTypeRepository, ErrorTypeRepository parentErrorTypeRepository) {
        this.childErrorTypeRepository = childErrorTypeRepository;
        this.parentErrorTypeRepository = parentErrorTypeRepository;
    }

    @Override
    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        return this.childErrorTypeRepository.addErrorType(errorTypeIdentifier, parentErrorType);
    }

    @Override
    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        return this.childErrorTypeRepository.addInternalErrorType(errorTypeIdentifier, parentErrorType);
    }

    @Override
    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        Optional<ErrorType> errorType = this.childErrorTypeRepository.lookupErrorType(errorTypeComponentIdentifier);
        if (!errorType.isPresent()) {
            errorType = this.parentErrorTypeRepository.lookupErrorType(errorTypeComponentIdentifier);
        }
        return errorType;
    }

    @Override
    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        Optional<ErrorType> errorType = this.childErrorTypeRepository.getErrorType(errorTypeIdentifier);
        if (!errorType.isPresent()) {
            errorType = this.parentErrorTypeRepository.getErrorType(errorTypeIdentifier);
        }
        return errorType;
    }

    @Override
    public Collection<String> getErrorNamespaces() {
        return Stream.concat(this.parentErrorTypeRepository.getErrorNamespaces().stream(), this.childErrorTypeRepository.getErrorNamespaces().stream()).collect(Collectors.toSet());
    }

    @Override
    public ErrorType getAnyErrorType() {
        return this.childErrorTypeRepository.getAnyErrorType();
    }

    @Override
    public ErrorType getSourceErrorType() {
        return this.childErrorTypeRepository.getSourceErrorType();
    }

    @Override
    public ErrorType getSourceResponseErrorType() {
        return this.childErrorTypeRepository.getSourceResponseErrorType();
    }

    @Override
    public ErrorType getCriticalErrorType() {
        return this.childErrorTypeRepository.getCriticalErrorType();
    }
}

