/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;

public class ErrorHandlerContextManager {
    public static final String ERROR_HANDLER_CONTEXT = "error.context";
    private final Map<String, Deque<ErrorHandlerContext>> items = new SmallMap<String, Deque<ErrorHandlerContext>>();

    private static ErrorHandlerContextManager from(CoreEvent event) {
        return (ErrorHandlerContextManager)((InternalEvent)event).getInternalParameter(ERROR_HANDLER_CONTEXT);
    }

    public static ErrorHandlerContext from(FlowExceptionHandler handler, CoreEvent coreEvent) {
        return ErrorHandlerContextManager.from((CoreEvent)coreEvent).items.get(ErrorHandlerContextManager.getParameterId(coreEvent, handler)).peekFirst();
    }

    public static CoreEvent addContext(FlowExceptionHandler handler, MessagingException exception, Consumer<CoreEvent> successCallback, Consumer<Throwable> errorCallback) {
        CoreEvent originalEvent = exception.getEvent();
        ErrorHandlerContextManager errorHandlerContextManager = ErrorHandlerContextManager.from(exception.getEvent());
        if (errorHandlerContextManager == null) {
            errorHandlerContextManager = new ErrorHandlerContextManager();
            originalEvent = EventQuickCopy.quickCopy(originalEvent, (Map<String, Object>)ImmutableMap.of((Object)ERROR_HANDLER_CONTEXT, (Object)errorHandlerContextManager));
        }
        errorHandlerContextManager.items.computeIfAbsent(ErrorHandlerContextManager.getParameterId(originalEvent, handler), key -> new ArrayDeque(1)).addFirst(new ErrorHandlerContext(exception, originalEvent, successCallback, errorCallback));
        return originalEvent;
    }

    public static void resolveHandling(FlowExceptionHandler handler, CoreEvent result) {
        ErrorHandlerContext errorHandlerContext = ErrorHandlerContextManager.from((CoreEvent)result).items.get(ErrorHandlerContextManager.getParameterId(result, handler)).removeFirst();
        MessagingException exception = errorHandlerContext.getException();
        if (exception.handled()) {
            errorHandlerContext.successCallback.accept(result);
        } else {
            if (exception.getEvent() != result) {
                exception.setProcessedEvent(result);
            }
            errorHandlerContext.errorCallback.accept(exception);
        }
    }

    public static void resolveHandling(FlowExceptionHandler handler, MessagingException exception) {
        ErrorHandlerContext errorHandlerContext = ErrorHandlerContextManager.from((CoreEvent)exception.getEvent()).items.get(ErrorHandlerContextManager.getParameterId(exception.getEvent(), handler)).removeFirst();
        errorHandlerContext.errorCallback.accept(exception);
    }

    private static String getParameterId(CoreEvent event, FlowExceptionHandler handler) {
        String id = event.getContext().getId();
        return (id != null ? id : "(null)").concat("_").concat(handler.toString());
    }

    public static class ErrorHandlerContext {
        private final MessagingException exception;
        private final CoreEvent originalEvent;
        private final Consumer<CoreEvent> successCallback;
        private final Consumer<Throwable> errorCallback;

        public ErrorHandlerContext(MessagingException exception, CoreEvent originalEvent, Consumer<CoreEvent> successCallback, Consumer<Throwable> errorCallback) {
            this.exception = exception;
            this.originalEvent = originalEvent;
            this.successCallback = successCallback;
            this.errorCallback = errorCallback;
        }

        public MessagingException getException() {
            return this.exception;
        }

        public CoreEvent getOriginalEvent() {
            return this.originalEvent;
        }
    }
}

