/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.lifecycle.HasLifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.NullLifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.RegistryLifecycleManager;
import org.mule.runtime.core.internal.lifecycle.phases.LifecyclePhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryLifecycleCallback<T>
implements LifecycleCallback<T>,
HasLifecycleInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryLifecycleCallback.class);
    protected final RegistryLifecycleManager registryLifecycleManager;
    private LifecycleInterceptor interceptor = new NullLifecycleInterceptor();

    public RegistryLifecycleCallback(RegistryLifecycleManager registryLifecycleManager) {
        this.registryLifecycleManager = registryLifecycleManager;
    }

    @Override
    public void onTransition(String phaseName, T object) throws MuleException {
        try {
            this.registryLifecycleManager.muleContext.withLifecycleLock(() -> this.doOnTransition(phaseName, object));
        }
        catch (RuntimeException e) {
            MuleException muleException = ExceptionUtils.extractOfType(e, MuleException.class).orElse(null);
            if (muleException != null) {
                throw muleException;
            }
            throw new MuleRuntimeException(ExceptionHelper.unwrap(e));
        }
    }

    private void doOnTransition(String phaseName, T object) throws MuleException {
        LifecyclePhase phase = this.registryLifecycleManager.phases.get(phaseName);
        LOGGER.debug("Applying lifecycle phase: {} for registry: {}", (Object)phase, (Object)object.getClass().getSimpleName());
        this.doApplyLifecycle(phase, new HashSet<Object>(), this.registryLifecycleManager.getObjectsForPhase(phase));
        this.interceptor.onPhaseCompleted(phase);
    }

    private void doApplyLifecycle(LifecyclePhase phase, Set<Object> duplicates, Collection<?> targetObjects) throws LifecycleException {
        if (CollectionUtils.isEmpty(targetObjects)) {
            return;
        }
        for (Object target : targetObjects) {
            if (target == null || duplicates.contains(target)) continue;
            LOGGER.debug("lifecycle phase: {} for object: {}", (Object)phase.getName(), (Object)target.getClass().getSimpleName());
            this.applyLifecycle(phase, duplicates, target);
        }
    }

    private void applyLifecycle(LifecyclePhase phase, Set<Object> duplicates, Object target) throws LifecycleException {
        try {
            if (this.interceptor.beforePhaseExecution(phase, target)) {
                phase.applyLifecycle(target);
                duplicates.add(target);
                this.interceptor.afterPhaseExecution(phase, target, Optional.empty());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Skipping the application of the '%s' lifecycle phase over a certain object because a %s interceptor of type [%s] indicated so. Object is: %s", phase.getName(), LifecycleInterceptor.class.getSimpleName(), this.interceptor.getClass().getName(), target.getClass().getSimpleName()));
            }
        }
        catch (Exception e) {
            this.interceptor.afterPhaseExecution(phase, target, Optional.of(e));
            if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") == null && (phase.getName().equals("dispose") || phase.getName().equals("stop"))) {
                LOGGER.info(String.format("Failure executing phase %s over object %s, error message is: %s", phase.getName(), target.getClass().getSimpleName(), e.getMessage()), (Object)e.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
            throw e;
        }
    }

    @Override
    public void setLifecycleInterceptor(LifecycleInterceptor interceptor) {
        this.interceptor = interceptor;
    }
}

