/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.LoggerMessageProcessor;
import org.mule.runtime.core.internal.processor.ParametersResolverProcessor;
import org.mule.runtime.core.internal.processor.interceptor.AbstractInterceptorAdapter;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorParameterValue;
import org.mule.runtime.core.internal.processor.interceptor.InterceptionException;
import org.mule.runtime.core.internal.processor.simple.ParseTemplateProcessor;
import org.mule.runtime.core.privileged.interception.ReactiveInterceptor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveInterceptorAdapter
extends AbstractInterceptorAdapter
implements ReactiveInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveInterceptorAdapter.class);
    private static final String BEFORE_METHOD_NAME = "before";
    private static final String AFTER_METHOD_NAME = "after";
    private final ProcessorInterceptorFactory interceptorFactory;

    public ReactiveInterceptorAdapter(ProcessorInterceptorFactory interceptorFactory) {
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public ReactiveProcessor apply(Processor component, ReactiveProcessor next) {
        if (!this.isInterceptable(component)) {
            return next;
        }
        ComponentLocation componentLocation = ((Component)((Object)component)).getLocation();
        if (!this.interceptorFactory.intercept(componentLocation)) {
            return next;
        }
        ProcessorInterceptor interceptor = (ProcessorInterceptor)this.interceptorFactory.get();
        Map dslParameters = (Map)((Component)((Object)component)).getAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS);
        ReactiveProcessor interceptedProcessor = this.doApply(component, next, componentLocation, interceptor, dslParameters);
        LOGGER.debug("Interceptor '{}' for processor '{}' configured.", (Object)interceptor, (Object)componentLocation.getLocation());
        return interceptedProcessor;
    }

    protected ReactiveProcessor doApply(Processor component, ReactiveProcessor next, ComponentLocation componentLocation, ProcessorInterceptor interceptor, Map<String, String> dslParameters) {
        if (this.implementsBeforeOrAfter(interceptor)) {
            LOGGER.debug("Configuring interceptor '{}' before and after processor '{}'...", (Object)interceptor, (Object)componentLocation.getLocation());
            return publisher -> Mono.subscriberContext().flatMapMany(ctx -> Flux.from((Publisher)publisher).flatMap(event -> Mono.just((Object)event).cast(InternalEvent.class).map(this.doBefore(interceptor, (Component)((Object)component), dslParameters)).cast(CoreEvent.class).transform((Function)next).onErrorMap(MessagingException.class, error -> this.createMessagingException(this.doAfter(interceptor, (Component)((Object)component), Optional.of(error.getCause())).apply((InternalEvent)error.getEvent()), error.getCause(), error.getFailingComponent() != null ? error.getFailingComponent() : (Component)((Object)component), Optional.of(error))).cast(InternalEvent.class).map(this.doAfter(interceptor, (Component)((Object)component), Optional.empty())).subscriberContext(innerCtx -> innerCtx.put((Object)"messageProcessors.withinProcessToApply", (Object)true)).onErrorStop()));
        }
        return next;
    }

    protected Function<InternalEvent, InternalEvent> doBefore(ProcessorInterceptor interceptor, Component component, Map<String, String> dslParameters) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.addResolvedParameters((InternalEvent)event, component, dslParameters);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling before() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            }
            try {
                Thread currentThread = Thread.currentThread();
                ClassLoader currentClassLoader = currentThread.getContextClassLoader();
                ClassLoader contextClassLoader = interceptor.getClass().getClassLoader();
                ClassUtils.setContextClassLoader(currentThread, currentClassLoader, contextClassLoader);
                try {
                    interceptor.before(component.getLocation(), this.getResolvedParams(eventWithResolvedParams), interceptionEvent);
                }
                finally {
                    ClassUtils.setContextClassLoader(currentThread, contextClassLoader, currentClassLoader);
                }
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                if (e.getCause() instanceof MessagingException) {
                    throw Exceptions.propagate((Throwable)e.getCause());
                }
                throw Exceptions.propagate((Throwable)new MessagingException((CoreEvent)interceptionEvent.resolve(), (Throwable)e, component));
            }
        };
    }

    protected Function<InternalEvent, InternalEvent> doAfter(ProcessorInterceptor interceptor, Component component, Optional<Throwable> thrown) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.removeResolvedParameters((InternalEvent)event);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling after() for '{}' in processor '{}'...", (Object)interceptor, (Object)component.getLocation().getLocation());
            }
            try {
                Thread currentThread = Thread.currentThread();
                ClassLoader currentClassLoader = currentThread.getContextClassLoader();
                ClassLoader contextClassLoader = interceptor.getClass().getClassLoader();
                ClassUtils.setContextClassLoader(currentThread, currentClassLoader, contextClassLoader);
                try {
                    interceptor.after(component.getLocation(), interceptionEvent, thrown);
                }
                finally {
                    ClassUtils.setContextClassLoader(currentThread, contextClassLoader, currentClassLoader);
                }
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)this.createMessagingException(interceptionEvent.resolve(), e, component, Optional.empty()));
            }
        };
    }

    private boolean implementsBeforeOrAfter(ProcessorInterceptor interceptor) {
        try {
            return !interceptor.getClass().getMethod(BEFORE_METHOD_NAME, ComponentLocation.class, Map.class, InterceptionEvent.class).isDefault() || !interceptor.getClass().getMethod(AFTER_METHOD_NAME, ComponentLocation.class, InterceptionEvent.class, Optional.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private boolean isInterceptable(Processor component) {
        return component instanceof Component && ((Component)((Object)component)).getLocation() != null;
    }

    @Override
    protected InternalEvent removeResolvedParameters(InternalEvent event) {
        Processor processor;
        if (this.internalParametersFrom(event).containsKey("core:interceptionResolvedContext") && (processor = (Processor)this.internalParametersFrom(event).get("core:interceptionComponent")) instanceof ParametersResolverProcessor) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disposing resolved parameters for processor {}...", (Object)((Component)((Object)processor)).getLocation().getLocation());
            }
            ((ParametersResolverProcessor)((Object)processor)).disposeResolvedParameters((ExecutionContext)this.internalParametersFrom(event).get("core:interceptionResolvedContext"));
        }
        return super.removeResolvedParameters(event);
    }

    @Override
    protected InternalEvent resolveParameters(InternalEvent event, Component component, Map<String, String> parameters) {
        Map<String, ProcessorParameterValue> resolvedParameters = SmallMap.forSize(parameters.size());
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String providedValue = entry.getValue();
            resolvedParameters.put(entry.getKey(), new DefaultProcessorParameterValue(entry.getKey(), providedValue, () -> {
                if (this.expressionManager.isExpression(providedValue)) {
                    if (component instanceof LoggerMessageProcessor || component instanceof ParseTemplateProcessor) {
                        return this.expressionManager.parseLogTemplate(providedValue, event, component.getLocation(), BindingContextUtils.NULL_BINDING_CONTEXT);
                    }
                    return this.expressionManager.evaluate(providedValue, (CoreEvent)event, component.getLocation()).getValue();
                }
                return String.valueOf(providedValue);
            }));
        }
        return this.setInternalParamsForNotParamResolver(component, resolvedParameters, event, InternalEvent.builder(event));
    }

    @Override
    protected InternalEvent setInternalParamsForNotParamResolver(Component component, Map<String, ProcessorParameterValue> resolvedParameters, InternalEvent event, InternalEvent.Builder builder) {
        if (component instanceof ParametersResolverProcessor) {
            try {
                ((ParametersResolverProcessor)((Object)component)).resolveParameters(builder, (params, context) -> {
                    resolvedParameters.putAll(params.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new DefaultProcessorParameterValue((String)e.getKey(), null, () -> ((Supplier)e.getValue()).get()))));
                    builder.addInternalParameter("core:interceptionResolvedContext", context);
                    builder.addInternalParameter("core:interceptionResolvedParams", resolvedParameters);
                    builder.addInternalParameter("core:interceptionComponent", component);
                });
                return builder.build();
            }
            catch (IllegalArgumentException | ExpressionRuntimeException e) {
                return super.setInternalParamsForNotParamResolver(component, resolvedParameters, event, builder);
            }
            catch (MuleException e) {
                throw new InterceptionException(e);
            }
        }
        return super.setInternalParamsForNotParamResolver(component, resolvedParameters, event, builder);
    }
}

