/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.ExceptionNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.SecurityNotification;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public abstract class AbstractExceptionListener
extends AbstractMessageProcessorOwner {
    protected static final String NOT_SET = "<not set>";
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    protected NotificationDispatcher notificationFirer;
    private final List<Processor> messageProcessors = new CopyOnWriteArrayList<Processor>();
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private boolean enableNotifications = true;
    protected String logException = Boolean.TRUE.toString();
    protected FlowConstructStatistics statistics;
    private String representation;

    public List<Processor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public void setMessageProcessors(List<Processor> processors) {
        if (processors == null) {
            throw new IllegalArgumentException("List of targets = null");
        }
        this.messageProcessors.clear();
        this.messageProcessors.addAll(processors);
    }

    @Override
    public final synchronized void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            this.doInitialise();
            super.initialise();
            this.representation = this.getClass().getSimpleName() + (this.getLocation() != null ? " @ " + this.getLocation().getLocation() : "");
            this.initialised.set(true);
        }
    }

    protected void doInitialise() throws InitialisationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initialising exception listener: " + this.toString());
        }
        this.doInitialise(this.muleContext);
    }

    @Deprecated
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
    }

    protected void fireNotification(Exception ex, CoreEvent event) {
        if (this.enableNotifications) {
            if (ex.getCause() != null && this.getCause(ex) instanceof SecurityException) {
                this.fireNotification(new SecurityNotification((SecurityException)this.getCause(ex), 401));
            } else {
                Component component = null;
                if (ex instanceof MessagingException) {
                    component = ((MessagingException)ex).getFailingComponent();
                }
                this.fireNotification(new ExceptionNotification(EnrichedNotificationInfo.createInfo(event, ex, component), this.getLocation()));
            }
        }
    }

    private Throwable getCause(Exception ex) {
        return ex.getCause() instanceof TypedException ? ex.getCause().getCause() : ex.getCause();
    }

    protected Pair<MuleException, String> resolveExceptionAndMessageToLog(Throwable t) {
        MuleException muleException = ExceptionHelper.getRootMuleException(t);
        String logMessage = null;
        if (muleException != null) {
            logMessage = !MuleException.isVerboseExceptions() && t instanceof EventProcessingException && ((EventProcessingException)t).getEvent().getError().map(e -> Errors.CORE_NAMESPACE_NAME.equals(e.getErrorType().getNamespace()) && "UNKNOWN".equals(e.getErrorType().getIdentifier())).orElse(false) != false ? ((MuleException)ExceptionHelper.sanitize(muleException)).getVerboseMessage() : muleException.getDetailedMessage();
        }
        return new Pair<MuleException, String>(muleException, logMessage);
    }

    protected void resolveAndLogException(Throwable t) {
        Pair<MuleException, String> resolvedException = this.resolveExceptionAndMessageToLog(t);
        if (resolvedException.getSecond() == null) {
            this.doLogException("Caught exception in Exception Strategy: " + t.getMessage(), t);
            return;
        }
        if (resolvedException.getFirst().getExceptionInfo().isAlreadyLogged()) {
            return;
        }
        this.doLogException(resolvedException.getSecond(), null);
        resolvedException.getFirst().getExceptionInfo().setAlreadyLogged(true);
    }

    protected void doLogException(String message, Throwable t) {
        if (t == null) {
            this.logger.error(message);
        } else {
            this.logger.error(message, t);
        }
    }

    protected void logFatal(CoreEvent event, Throwable t) {
        if (this.statistics != null && this.statistics.isEnabled()) {
            this.statistics.incFatalError();
        }
        String logUniqueId = StringUtils.defaultString((String)event.getCorrelationId(), (String)NOT_SET);
        String printableLogMessage = MessageFormat.format("Message identification summary here: id={0}, correlation={1}", logUniqueId, event.getGroupCorrelation());
        this.logger.error("Failed to dispatch message to error queue after it failed to process.  This may cause message loss. " + (event.getMessage() == null ? "" : printableLogMessage), t);
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    protected void fireNotification(Notification notification) {
        if (this.notificationFirer != null) {
            this.notificationFirer.dispatch(notification);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.debug("notificationFirer is not yet available for firing notifications, ignoring event: " + notification);
        }
    }

    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public void setLogException(String logException) {
        this.logException = logException;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }

    protected void commit() {
        TransactionCoordination.getInstance().commitCurrentTransaction();
    }

    protected void rollback(Exception ex) {
        TransactionCoordination.getInstance().rollbackCurrentTransaction();
    }

    public void setNotificationFirer(NotificationDispatcher notificationFirer) {
        this.notificationFirer = notificationFirer;
    }

    public void setStatistics(FlowConstructStatistics statistics) {
        this.statistics = statistics;
    }

    public String toString() {
        return this.representation;
    }
}

